/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.actionexecutor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.actionexecutor.ActionExecutor;
import org.wso2.diagnostics.utils.ConfigMapHolder;

public class Netstat
implements ActionExecutor {
    private static Logger log = LogManager.getLogger(Netstat.class);
    private String command;

    public Netstat() {
        Map<String, Object> configuration = ConfigMapHolder.getInstance().getConfigMap();
        ArrayList actionExecutorConfigs = (ArrayList)configuration.get("action_executor_configuration");
        for (Object actionExecutorConfig : actionExecutorConfigs) {
            Map actionExecutorConfigMap = (Map)actionExecutorConfig;
            if (!actionExecutorConfigMap.get("executor").equals("Netstat")) continue;
            this.command = (String)actionExecutorConfigMap.get("command");
        }
    }

    @Override
    public void execute(String filepath) {
        block6: {
            if (new File(filepath).exists()) {
                String filename = "/netstat-output.txt ";
                String frame = filepath + filename;
                try {
                    if (this.command != null) {
                        Process process = Runtime.getRuntime().exec(this.command);
                        Scanner scanner = new Scanner(process.getInputStream(), "IBM850");
                        scanner.useDelimiter("\\A");
                        try {
                            FileWriter writer = new FileWriter(frame);
                            writer.write(scanner.next());
                            writer.close();
                        }
                        catch (IOException e) {
                            log.error("Unable to do write in file in netstat");
                        }
                        scanner.close();
                        log.info("Netstat executed successfully");
                        break block6;
                    }
                    log.error("Unable to detect the OS");
                }
                catch (IOException e) {
                    log.error("Unable to do netstat");
                }
            }
        }
    }
}

