/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;

public class ScrollableEditorPanel
extends JPanel
implements Scrollable {
    private JEditorPane editor = null;
    private List markers = new ArrayList();

    public ScrollableEditorPanel(JEditorPane editor) {
        super(new BorderLayout());
        this.editor = editor;
        this.add((Component)editor, "Center");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.editor.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.editor.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    public boolean getScrollableTracksViewportWidth() {
        View view = this.editor.getUI().getRootView(this.editor).getView(0);
        if (view instanceof WrappedPlainView) {
            return true;
        }
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

