/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLScanner;
import org.bounce.text.xml.XMLViewUtilities;
import org.webharvest.gui.BreakpointCollection;
import org.webharvest.gui.XmlTextPane;

public class XMLView
extends PlainView {
    public static final Color DEBUG_NORMAL_COLOR = new Color(255, 200, 200);
    public static final Color DEBUG_STOP_COLOR = new Color(0, 0, 255);
    public static final Color LINE_MARKER_COLOR = new Color(192, 192, 192);
    public static final Color ERROR_COLOR = new Color(255, 0, 0);
    private XMLScanner scanner = null;
    private XMLContext context = null;
    private XmlTextPane xmlTextPane;
    private Color bgPaintColor = null;

    public XMLView(XMLContext context, Element elem, XmlTextPane xmlTextPane) throws IOException {
        super(elem);
        this.context = context;
        this.xmlTextPane = xmlTextPane;
        Document doc = this.getDocument();
        this.scanner = new XMLScanner(doc);
    }

    public void paint(Graphics g, Shape a) {
        this.paintX(g, a);
        super.paint(g, a);
        this.scanner.setValid(false);
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        return XMLViewUtilities.drawUnselectedText(this, this.scanner, this.context, g, x, y, start, end);
    }

    protected int drawSelectedText(Graphics g, int x, int y, int start, int end) throws BadLocationException {
        return XMLViewUtilities.drawSelectedText(this, this.scanner, this.context, g, x, y, start, end);
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        BreakpointCollection breakpoints;
        this.bgPaintColor = null;
        if (this.xmlTextPane.getErrorLine() == lineIndex) {
            this.bgPaintColor = ERROR_COLOR;
        }
        if (this.bgPaintColor == null && this.xmlTextPane.getStopDebugLine() == lineIndex) {
            this.bgPaintColor = DEBUG_STOP_COLOR;
        }
        if (this.bgPaintColor == null && this.xmlTextPane.getMarkerLine() == lineIndex) {
            this.bgPaintColor = LINE_MARKER_COLOR;
        }
        if (this.bgPaintColor == null && (breakpoints = this.xmlTextPane.getBreakpoints()) != null && breakpoints.isThereBreakpoint(lineIndex)) {
            this.bgPaintColor = DEBUG_NORMAL_COLOR;
        }
        super.drawLine(lineIndex, g, x, y);
    }

    public void paintX(Graphics g, Shape a) {
        Rectangle alloc = (Rectangle)a;
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int linesBelow = Math.max(0, heightBelow / fontHeight);
        int heightAbove = clip.y - alloc.y;
        int linesAbove = Math.max(0, heightAbove / fontHeight);
        int linesTotal = alloc.height / fontHeight;
        if (alloc.height % fontHeight != 0) {
            ++linesTotal;
        }
        Rectangle lineArea = this.lineToRect(a, linesAbove);
        int y = lineArea.y + this.metrics.getAscent();
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int endLine = Math.min(lineCount, linesTotal - linesBelow);
        for (int line = linesAbove; line < endLine; ++line) {
            BreakpointCollection breakpoints;
            this.bgPaintColor = null;
            if (this.xmlTextPane.getErrorLine() == line) {
                this.bgPaintColor = ERROR_COLOR;
            }
            if (this.bgPaintColor == null && this.xmlTextPane.getStopDebugLine() == line) {
                this.bgPaintColor = DEBUG_STOP_COLOR;
            }
            if (this.bgPaintColor == null && this.xmlTextPane.getMarkerLine() == line) {
                this.bgPaintColor = LINE_MARKER_COLOR;
            }
            if (this.bgPaintColor == null && (breakpoints = this.xmlTextPane.getBreakpoints()) != null && breakpoints.isThereBreakpoint(line)) {
                this.bgPaintColor = DEBUG_NORMAL_COLOR;
            }
            if (this.bgPaintColor != null) {
                g.setColor(this.bgPaintColor);
                FontMetrics fontMetrics = g.getFontMetrics();
                int rectY = y - fontMetrics.getAscent();
                g.fillRect(0, rectY, this.getContainer().getWidth(), fontHeight);
            }
            y += fontHeight;
        }
    }

    public Color getBgPaintColor() {
        return this.bgPaintColor;
    }
}

