/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.webharvest.definition.XmlParser;
import org.xml.sax.InputSource;

public class XmlNode
extends HashMap {
    protected static final Log log = LogFactory.getLog(XmlNode.class);
    private static final boolean IGNORE_NAMESPACE = true;
    private static final boolean IGNORE_CASE = true;
    private String name;
    private XmlNode parent;
    private Map attributes = new HashMap();
    private List elementList = new ArrayList();
    private StringBuffer textBuff = new StringBuffer();
    private transient StringBuffer tmpBuf = new StringBuffer();
    private int lineNumbwe;
    private int columnNumber;

    public static XmlNode getInstance(InputSource in) {
        return XmlParser.parse(in);
    }

    protected XmlNode(String name, XmlNode parent) {
        this.name = this.adaptName(name);
        this.parent = parent;
        if (parent != null) {
            parent.addElement(this);
        }
    }

    private String adaptName(String s) {
        int index = s.indexOf(58);
        if (index >= 0) {
            s = s.substring(index + 1);
        }
        s = s.toLowerCase();
        return s;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.textBuff == null ? null : this.textBuff.toString();
    }

    public XmlNode getParent() {
        return this.parent;
    }

    private Object getSeq(String key) {
        StringTokenizer strTkzr = new StringTokenizer(key, "./\\[]");
        XmlNode currValue = this;
        while (strTkzr.hasMoreTokens()) {
            String currKey = strTkzr.nextToken();
            if (currValue instanceof Map) {
                currValue = ((Map)currValue).get(currKey);
                continue;
            }
            if (currValue instanceof List) {
                try {
                    List list = (List)((Object)currValue);
                    int index = Integer.parseInt(currKey);
                    if (index < 0 || index >= list.size()) continue;
                    currValue = list.get(index);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
        return currValue;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String sKey = (String)(key = ((String)key).toLowerCase());
        if (sKey.indexOf(47) >= 0 || sKey.indexOf(46) >= 0 || sKey.indexOf(92) >= 0 || sKey.indexOf(91) >= 0) {
            return this.getSeq(sKey);
        }
        if (sKey.equalsIgnoreCase("_value")) {
            return this.getText();
        }
        if (this.containsKey(key)) {
            return super.get(key);
        }
        return this.attributes.get(key);
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(this.adaptName(name), value);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attName) {
        return (String)this.attributes.get(attName);
    }

    public void addElement(XmlNode elementNode) {
        this.flushText();
        String elementName = elementNode.getName();
        if (!this.containsKey(elementName)) {
            this.put(elementName, new ArrayList());
        }
        ArrayList elementsForName = (ArrayList)this.get(elementName);
        elementsForName.add(elementNode);
        this.elementList.add(elementNode);
    }

    public void addElement(String value) {
        this.tmpBuf.append(value);
    }

    void flushText() {
        String value = this.tmpBuf.toString();
        if (!"".equals(value)) {
            StringTokenizer tokenizer = new StringTokenizer(value, "\n\r");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() == 0) continue;
                this.elementList.add(token);
                if (this.textBuff.length() > 0) {
                    this.textBuff.append('\n');
                }
                this.textBuff.append(token);
            }
            this.tmpBuf.delete(0, this.tmpBuf.length());
        }
    }

    public Object getElement(String name) {
        return super.get(name);
    }

    public List getElementList() {
        return this.elementList;
    }

    public void print() {
        this.print(0);
    }

    private void print(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("     ");
        }
        System.out.print(this.name + ": " + this.attributes + ": TEXT = [" + this.textBuff + "]\n");
        for (Object element : this.elementList) {
            if (element instanceof XmlNode) {
                XmlNode childNode = (XmlNode)element;
                childNode.print(level + 1);
                continue;
            }
            for (int i = 0; i <= level; ++i) {
                System.out.print("     ");
            }
            System.out.println((String)element);
        }
    }

    public void setLocation(int lineNumber, int columnNumber) {
        this.lineNumbwe = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumbwe;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

