/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.exception.PluginException;
import org.webharvest.gui.GuiUtils;
import org.webharvest.utils.CommonUtil;

public class Settings
implements Serializable {
    private static final String CONFIG_FILE_PATH = System.getProperty("java.io.tmpdir") + "/webharvest.config";
    private static final int MAX_RECENT_FILES = 20;
    private String workingPath = System.getProperty("java.io.tmpdir");
    private String fileCharset = "UTF-8";
    private boolean isProxyEnabled;
    private String proxyServer;
    private int proxyPort = -1;
    private boolean isProxyAuthEnabled;
    private String proxyUserename;
    private String proxyPassword;
    private boolean isNtlmAuthEnabled;
    private String ntlmHost;
    private String ntlmDomain;
    private boolean isShowHierarchyByDefault = true;
    private boolean isShowLogByDefault = true;
    private boolean isShowLineNumbersByDefault = true;
    private boolean isDynamicConfigLocate = true;
    private boolean isShowFinishDialog = true;
    private String[] plugins = new String[0];
    private List recentFiles = new LinkedList();

    public Settings() {
        try {
            this.readFromFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            GuiUtils.showErrorMessage("Error while reading programs settings: " + e.getMessage());
        }
    }

    public boolean isProxyAuthEnabled() {
        return this.isProxyAuthEnabled;
    }

    public void setProxyAuthEnabled(boolean proxyAuthEnabled) {
        this.isProxyAuthEnabled = proxyAuthEnabled;
    }

    public boolean isProxyEnabled() {
        return this.isProxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.isProxyEnabled = proxyEnabled;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public String getProxyUserename() {
        return this.proxyUserename;
    }

    public void setProxyUserename(String proxyUserename) {
        this.proxyUserename = proxyUserename;
    }

    public boolean isNtlmAuthEnabled() {
        return this.isNtlmAuthEnabled;
    }

    public void setNtlmAuthEnabled(boolean ntlmAuthEnabled) {
        this.isNtlmAuthEnabled = ntlmAuthEnabled;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    public String getNtlmHost() {
        return this.ntlmHost;
    }

    public void setNtlmHost(String ntlmHost) {
        this.ntlmHost = ntlmHost;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public void setFileCharset(String fileCharset) {
        this.fileCharset = fileCharset;
    }

    public boolean isDynamicConfigLocate() {
        return this.isDynamicConfigLocate;
    }

    public void setDynamicConfigLocate(boolean dynamicConfigLocate) {
        this.isDynamicConfigLocate = dynamicConfigLocate;
    }

    public boolean isShowFinishDialog() {
        return this.isShowFinishDialog;
    }

    public void setShowFinishDialog(boolean showFinishDialog) {
        this.isShowFinishDialog = showFinishDialog;
    }

    public boolean isShowHierarchyByDefault() {
        return this.isShowHierarchyByDefault;
    }

    public void setShowHierarchyByDefault(boolean showHierarchyByDefault) {
        this.isShowHierarchyByDefault = showHierarchyByDefault;
    }

    public boolean isShowLogByDefault() {
        return this.isShowLogByDefault;
    }

    public void setShowLogByDefault(boolean showLogByDefault) {
        this.isShowLogByDefault = showLogByDefault;
    }

    public boolean isShowLineNumbersByDefault() {
        return this.isShowLineNumbersByDefault;
    }

    public void setShowLineNumbersByDefault(boolean showLineNumbersByDefault) {
        this.isShowLineNumbersByDefault = showLineNumbersByDefault;
    }

    public String[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(String[] plugins) {
        this.plugins = plugins == null ? new String[]{} : plugins;
    }

    public List getRecentFiles() {
        return this.recentFiles;
    }

    public void addRecentFile(String filePath) {
        int index = CommonUtil.findValueInCollection(this.recentFiles, filePath);
        if (index >= 0) {
            this.recentFiles.remove(index);
        }
        this.recentFiles.add(0, filePath);
        int recentFilesCount = this.recentFiles.size();
        if (recentFilesCount > 20) {
            this.recentFiles.remove(recentFilesCount - 1);
        }
    }

    private void writeString(ObjectOutputStream out, String s) throws IOException {
        if (s != null) {
            out.writeInt(s.getBytes().length);
            out.writeBytes(s);
        } else {
            out.writeInt(0);
        }
    }

    private String readString(ObjectInputStream in, String defaultValue) throws IOException {
        try {
            byte[] bytes = new byte[in.readInt()];
            in.read(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    private boolean readBoolean(ObjectInputStream in, boolean defaultValue) throws IOException {
        try {
            return in.readBoolean();
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    private int readInt(ObjectInputStream in, int defaultValue) throws IOException {
        try {
            return in.readInt();
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeString(out, this.workingPath);
        out.writeBoolean(this.isProxyEnabled);
        this.writeString(out, this.proxyServer);
        out.writeInt(this.proxyPort);
        out.writeBoolean(this.isProxyAuthEnabled);
        this.writeString(out, this.proxyUserename);
        this.writeString(out, this.proxyPassword);
        out.writeBoolean(this.isNtlmAuthEnabled);
        this.writeString(out, this.ntlmHost);
        this.writeString(out, this.ntlmDomain);
        out.writeBoolean(this.isShowHierarchyByDefault);
        out.writeBoolean(this.isShowLogByDefault);
        out.writeBoolean(this.isShowLineNumbersByDefault);
        out.writeBoolean(this.isDynamicConfigLocate);
        this.writeString(out, this.fileCharset);
        out.writeBoolean(this.isShowFinishDialog);
        out.writeInt(this.plugins.length);
        for (int i = 0; i < this.plugins.length; ++i) {
            this.writeString(out, this.plugins[i]);
        }
        out.writeInt(this.recentFiles.size());
        Iterator iterator = this.recentFiles.iterator();
        while (iterator.hasNext()) {
            this.writeString(out, (String)iterator.next());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.workingPath = this.readString(in, this.workingPath);
        this.isProxyEnabled = this.readBoolean(in, this.isProxyEnabled);
        this.proxyServer = this.readString(in, this.proxyServer);
        this.proxyPort = this.readInt(in, this.proxyPort);
        this.isProxyAuthEnabled = this.readBoolean(in, this.isProxyAuthEnabled);
        this.proxyUserename = this.readString(in, this.proxyUserename);
        this.proxyPassword = this.readString(in, this.proxyPassword);
        this.isNtlmAuthEnabled = this.readBoolean(in, this.isNtlmAuthEnabled);
        this.ntlmHost = this.readString(in, this.ntlmHost);
        this.ntlmDomain = this.readString(in, this.ntlmDomain);
        this.isShowHierarchyByDefault = this.readBoolean(in, this.isShowHierarchyByDefault);
        this.isShowLogByDefault = this.readBoolean(in, this.isShowLogByDefault);
        this.isShowLineNumbersByDefault = this.readBoolean(in, this.isShowLineNumbersByDefault);
        this.isDynamicConfigLocate = this.readBoolean(in, this.isDynamicConfigLocate);
        this.fileCharset = this.readString(in, this.fileCharset);
        this.isShowFinishDialog = this.readBoolean(in, this.isShowFinishDialog);
        int pluginsCount = this.readInt(in, 0);
        this.plugins = new String[pluginsCount];
        for (int i = 0; i < pluginsCount; ++i) {
            this.plugins[i] = this.readString(in, "");
            try {
                DefinitionResolver.registerPlugin(this.plugins[i]);
                continue;
            }
            catch (PluginException pluginException) {
                // empty catch block
            }
        }
        int recentFilesCount = this.readInt(in, 0);
        this.recentFiles.clear();
        for (int i = 0; i < recentFilesCount; ++i) {
            this.recentFiles.add(this.readString(in, ""));
        }
    }

    private void readFromFile() throws IOException {
        File configFile = new File(CONFIG_FILE_PATH);
        if (configFile.exists()) {
            FileInputStream fis = new FileInputStream(configFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.readObject(ois);
        }
    }

    public void writeToFile() throws IOException {
        File configFile = new File(CONFIG_FILE_PATH);
        FileOutputStream fos = new FileOutputStream(configFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        this.writeObject(oos);
        oos.flush();
        fos.flush();
        oos.close();
        fos.close();
    }

    public void writeSilentlyToFile() {
        try {
            this.writeToFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

