/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.exception.PluginException;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.Ide;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.Settings;
import org.webharvest.gui.component.CommonDialog;
import org.webharvest.gui.component.FixedSizeButton;
import org.webharvest.gui.component.FixedSizeTextField;
import org.webharvest.gui.component.InputDialog;
import org.webharvest.gui.component.SmallButton;
import org.webharvest.gui.component.WHCheckBox;
import org.webharvest.gui.component.WHComboBox;
import org.webharvest.gui.component.WHList;
import org.webharvest.gui.component.WHScrollPane;

public class SettingsDialog
extends CommonDialog
implements ChangeListener {
    private Ide ide;
    private JTextField workingPathField;
    private JComboBox fileCharsetComboBox;
    private JTextField proxyServerField;
    private JTextField proxyPortField;
    private JTextField proxyUsernameField;
    private JTextField proxyPasswordField;
    private JTextField ntlmHostField;
    private JTextField ntlmDomainField;
    private JCheckBox proxyEnabledCheckBox;
    private JCheckBox proxyAuthEnabledCheckBox;
    private JCheckBox ntlmEnabledCheckBox;
    private JLabel proxyUsernameLabel;
    private JLabel proxyPasswordLabel;
    private JLabel proxyPortLabel;
    private JLabel proxyServerLabel;
    private JLabel ntlmHostLabel;
    private JLabel ntlmDomainLabel;
    private JCheckBox showHierarchyByDefaultCheckBox;
    private JCheckBox showLogByDefaultCheckBox;
    private JCheckBox showLineNumbersByDefaultCheckBox;
    private JCheckBox dynamicConfigLocateCheckBox;
    private JCheckBox showFinishDialogCheckBox;
    private JButton pluginAddButton;
    private JButton pluginEditButton;
    private JButton pluginRemoveButton;
    private PluginListModel pluginListModel;
    private JList pluginsList;
    private final JFileChooser pathChooser = new JFileChooser();

    public SettingsDialog(Ide ide) throws HeadlessException {
        super("Settings");
        this.ide = ide;
        this.setResizable(false);
        this.pathChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.exists() && f.isDirectory();
            }

            public String getDescription() {
                return "All directories";
            }
        });
        this.pathChooser.setMultiSelectionEnabled(false);
        this.pathChooser.setFileSelectionMode(1);
        this.createGUI();
    }

    private void createGUI() {
        Container contentPane = this.getContentPane();
        JPanel generalPanel = new JPanel(new GridBagLayout());
        generalPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(2, 5, 2, 5);
        this.workingPathField = new FixedSizeTextField(250, -1);
        SortedMap<String, Charset> charsetsMap = Charset.availableCharsets();
        Vector allSupportedCharsets = new Vector(charsetsMap.keySet());
        this.fileCharsetComboBox = new WHComboBox(allSupportedCharsets);
        this.proxyServerField = new FixedSizeTextField(250, -1);
        this.proxyPortField = new FixedSizeTextField(250, -1);
        this.proxyUsernameField = new FixedSizeTextField(250, -1);
        this.proxyPasswordField = new FixedSizeTextField(250, -1);
        this.ntlmHostField = new FixedSizeTextField(250, -1);
        this.ntlmDomainField = new FixedSizeTextField(250, -1);
        this.proxyEnabledCheckBox = new WHCheckBox("Proxy server enabled");
        this.proxyEnabledCheckBox.addChangeListener(this);
        this.proxyAuthEnabledCheckBox = new WHCheckBox("Proxy authentication enabled");
        this.proxyAuthEnabledCheckBox.addChangeListener(this);
        this.ntlmEnabledCheckBox = new WHCheckBox("Use NTLM authentication scheme");
        this.ntlmEnabledCheckBox.addChangeListener(this);
        constraints.gridx = 0;
        constraints.gridy = 0;
        generalPanel.add((Component)new JLabel("Output path"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        JPanel pathPanel = new JPanel(new FlowLayout(0, 0, 0));
        pathPanel.add(this.workingPathField);
        SmallButton chooseDirButton = new SmallButton("..."){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                return new Dimension(30, SettingsDialog.this.workingPathField.getHeight());
            }
        };
        chooseDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File selectedDir;
                int returnVal = SettingsDialog.this.pathChooser.showOpenDialog(SettingsDialog.this);
                if (returnVal == 0 && (selectedDir = SettingsDialog.this.pathChooser.getSelectedFile()) != null) {
                    SettingsDialog.this.workingPathField.setText(selectedDir.getAbsolutePath());
                }
            }
        });
        pathPanel.add(chooseDirButton);
        generalPanel.add((Component)pathPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        generalPanel.add((Component)new JLabel("File encoding"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        generalPanel.add((Component)this.fileCharsetComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        generalPanel.add((Component)this.proxyEnabledCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        this.proxyServerLabel = new JLabel("Proxy server");
        generalPanel.add((Component)this.proxyServerLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        generalPanel.add((Component)this.proxyServerField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        this.proxyPortLabel = new JLabel("Proxy port (blank is default)");
        generalPanel.add((Component)this.proxyPortLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 4;
        generalPanel.add((Component)this.proxyPortField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 5;
        generalPanel.add((Component)this.proxyAuthEnabledCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 6;
        this.proxyUsernameLabel = new JLabel("Proxy username");
        generalPanel.add((Component)this.proxyUsernameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 6;
        generalPanel.add((Component)this.proxyUsernameField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 7;
        this.proxyPasswordLabel = new JLabel("Proxy password");
        generalPanel.add((Component)this.proxyPasswordLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 7;
        generalPanel.add((Component)this.proxyPasswordField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 8;
        generalPanel.add((Component)this.ntlmEnabledCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 9;
        this.ntlmHostLabel = new JLabel("NT host");
        generalPanel.add((Component)this.ntlmHostLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 9;
        generalPanel.add((Component)this.ntlmHostField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 10;
        this.ntlmDomainLabel = new JLabel("NT domain");
        generalPanel.add((Component)this.ntlmDomainLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 10;
        generalPanel.add((Component)this.ntlmDomainField, constraints);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.createOkButton());
        buttonPanel.add(this.createCancelButton());
        JPanel viewPanel = new JPanel();
        viewPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        viewPanel.setLayout(new BoxLayout(viewPanel, 3));
        this.showHierarchyByDefaultCheckBox = new WHCheckBox("Show hierarchy panel by default");
        this.showLogByDefaultCheckBox = new WHCheckBox("Show log panel by default");
        this.showLineNumbersByDefaultCheckBox = new WHCheckBox("Show line numbers by default");
        this.dynamicConfigLocateCheckBox = new WHCheckBox("Dynamically locate processors in runtime");
        this.showFinishDialogCheckBox = new WHCheckBox("Show info/error dialog when execution finishes");
        viewPanel.add(this.showHierarchyByDefaultCheckBox);
        viewPanel.add(this.showLogByDefaultCheckBox);
        viewPanel.add(this.showLineNumbersByDefaultCheckBox);
        viewPanel.add(this.dynamicConfigLocateCheckBox);
        viewPanel.add(this.showFinishDialogCheckBox);
        JPanel pluginsPanel = new JPanel(new BorderLayout(5, 0));
        JPanel pluginButtonsPanel = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        pluginButtonsPanel.setLayout(springLayout);
        pluginButtonsPanel.setBorder(new EmptyBorder(3, 0, 3, 3));
        pluginButtonsPanel.setPreferredSize(new Dimension(116, 1));
        String pluginInputMsg = "Full class name of the plugin";
        this.pluginAddButton = new FixedSizeButton("Add plugin", 110, 22);
        this.pluginAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String className = new InputDialog(SettingsDialog.this, "Input", "Full class name of the plugin", "", 50, null).getValue();
                if (className != null) {
                    SettingsDialog.this.pluginListModel.addElement(className, true);
                    SettingsDialog.this.pluginsList.setSelectedIndex(SettingsDialog.this.pluginListModel.size() - 1);
                }
            }
        });
        this.pluginEditButton = new FixedSizeButton("Edit plugin", 110, 22);
        final ActionListener editListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isSet;
                String oldClassName;
                String className;
                int index = SettingsDialog.this.pluginsList.getSelectedIndex();
                if (index >= 0 && (className = new InputDialog(SettingsDialog.this, "Input", "Full class name of the plugin", oldClassName = SettingsDialog.this.pluginsList.getSelectedValue().toString(), 50, null).getValue()) != null && !className.equals(oldClassName) && (isSet = SettingsDialog.this.pluginListModel.setElement(className, index))) {
                    DefinitionResolver.unregisterPlugin(oldClassName);
                }
            }
        };
        this.pluginEditButton.addActionListener(editListener);
        this.pluginRemoveButton = new FixedSizeButton("Remove plugin", 110, 22);
        this.pluginRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = SettingsDialog.this.pluginsList.getSelectedIndex();
                if (index >= 0) {
                    String oldClassName = SettingsDialog.this.pluginsList.getSelectedValue().toString();
                    DefinitionResolver.unregisterPlugin(oldClassName);
                    SettingsDialog.this.pluginListModel.remove(index);
                    SettingsDialog.this.pluginsList.setSelectedIndex(Math.min(index, SettingsDialog.this.pluginListModel.size() - 1));
                }
            }
        });
        pluginButtonsPanel.add(this.pluginAddButton);
        pluginButtonsPanel.add(this.pluginEditButton);
        pluginButtonsPanel.add(this.pluginRemoveButton);
        springLayout.putConstraint("North", (Component)this.pluginEditButton, 5, "South", (Component)this.pluginAddButton);
        springLayout.putConstraint("North", (Component)this.pluginRemoveButton, 5, "South", (Component)this.pluginEditButton);
        pluginsPanel.add((Component)pluginButtonsPanel, "East");
        JPanel pluginsListPanel = new JPanel(new BorderLayout(5, 5));
        pluginsListPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.pluginListModel = new PluginListModel();
        this.pluginsList = new WHList((ListModel)this.pluginListModel);
        this.pluginsList.setCellRenderer(new PluginListCellRenderer());
        this.pluginsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SettingsDialog.this.updateControls();
            }
        });
        this.pluginsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && SettingsDialog.this.pluginsList.getSelectedIndex() >= 0) {
                    editListener.actionPerformed(null);
                }
            }
        });
        pluginsListPanel.add((Component)new WHScrollPane(this.pluginsList), "Center");
        pluginsPanel.add((Component)pluginsListPanel, "Center");
        tabbedPane.addTab("General", null, generalPanel, null);
        tabbedPane.addTab("View", null, viewPanel, null);
        tabbedPane.addTab("Plugins", null, pluginsPanel, null);
        contentPane.add((Component)tabbedPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.updateControls();
        this.pack();
    }

    private void fillValues() {
        Settings settings = this.ide.getSettings();
        this.workingPathField.setText(settings.getWorkingPath());
        this.fileCharsetComboBox.setSelectedItem(settings.getFileCharset());
        this.proxyServerField.setText(settings.getProxyServer());
        this.proxyPortField.setText(settings.getProxyPort() > 0 ? "" + settings.getProxyPort() : "");
        this.proxyUsernameField.setText(settings.getProxyUserename());
        this.proxyPasswordField.setText(settings.getProxyPassword());
        this.proxyEnabledCheckBox.setSelected(settings.isProxyEnabled());
        this.proxyAuthEnabledCheckBox.setSelected(settings.isProxyAuthEnabled());
        this.ntlmEnabledCheckBox.setSelected(settings.isNtlmAuthEnabled());
        this.ntlmHostField.setText(settings.getNtlmHost());
        this.ntlmDomainField.setText(settings.getNtlmDomain());
        this.showHierarchyByDefaultCheckBox.setSelected(settings.isShowHierarchyByDefault());
        this.showLogByDefaultCheckBox.setSelected(settings.isShowLogByDefault());
        this.showLineNumbersByDefaultCheckBox.setSelected(settings.isShowLineNumbersByDefault());
        this.dynamicConfigLocateCheckBox.setSelected(settings.isDynamicConfigLocate());
        this.showFinishDialogCheckBox.setSelected(settings.isShowFinishDialog());
        this.pluginListModel.clear();
        String[] plugins = settings.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            this.pluginListModel.addElement(plugins[i], false);
        }
    }

    private void undoPlugins() {
        int i;
        Map externalPlugins = DefinitionResolver.getExternalPlugins();
        Settings settings = this.ide.getSettings();
        String[] plugins = settings.getPlugins();
        HashSet<String> pluginSet = new HashSet<String>();
        for (int i2 = 0; i2 < plugins.length; ++i2) {
            pluginSet.add(plugins[i2]);
        }
        HashSet<String> listSet = new HashSet<String>();
        int count = this.pluginListModel.getSize();
        for (i = 0; i < count; ++i) {
            PluginListItem item = (PluginListItem)this.pluginListModel.get(i);
            listSet.add(item.className);
            if (!item.isValid() || pluginSet.contains(item.className)) continue;
            DefinitionResolver.unregisterPlugin(item.className);
        }
        for (i = 0; i < plugins.length; ++i) {
            String currPlugin = plugins[i];
            if (listSet.contains(currPlugin) || DefinitionResolver.isPluginRegistered(currPlugin)) continue;
            try {
                DefinitionResolver.registerPlugin(currPlugin);
                continue;
            }
            catch (PluginException pluginException) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.fillValues();
        } else {
            this.undoPlugins();
        }
        super.setVisible(b);
    }

    private void define() {
        Settings settings = this.ide.getSettings();
        settings.setWorkingPath(this.workingPathField.getText());
        settings.setFileCharset(this.fileCharsetComboBox.getSelectedItem().toString());
        settings.setProxyServer(this.proxyServerField.getText());
        int port = -1;
        try {
            port = Integer.parseInt(this.proxyPortField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.setProxyPort(port);
        settings.setProxyUserename(this.proxyUsernameField.getText());
        settings.setProxyPassword(this.proxyPasswordField.getText());
        settings.setProxyEnabled(this.proxyEnabledCheckBox.isSelected());
        settings.setProxyAuthEnabled(this.proxyAuthEnabledCheckBox.isSelected());
        settings.setNtlmAuthEnabled(this.ntlmEnabledCheckBox.isSelected());
        settings.setNtlmHost(this.ntlmHostField.getText());
        settings.setNtlmDomain(this.ntlmDomainField.getText());
        settings.setShowHierarchyByDefault(this.showHierarchyByDefaultCheckBox.isSelected());
        settings.setShowLogByDefault(this.showLogByDefaultCheckBox.isSelected());
        settings.setShowLineNumbersByDefault(this.showLineNumbersByDefaultCheckBox.isSelected());
        settings.setDynamicConfigLocate(this.dynamicConfigLocateCheckBox.isSelected());
        settings.setShowFinishDialog(this.showFinishDialogCheckBox.isSelected());
        int pluginCount = this.pluginListModel.getSize();
        String[] plugins = new String[pluginCount];
        for (int i = 0; i < pluginCount; ++i) {
            PluginListItem item = (PluginListItem)this.pluginListModel.get(i);
            plugins[i] = item.className;
        }
        settings.setPlugins(plugins);
        try {
            settings.writeToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            GuiUtils.showErrorMessage("Error saving programs settings: " + e.getMessage());
        }
        this.updateControls();
        this.setVisible(false);
    }

    private void updateControls() {
        boolean isProxyEnabled = this.proxyEnabledCheckBox.isSelected();
        boolean isProxyAuthEnabled = this.proxyAuthEnabledCheckBox.isSelected();
        boolean isNtlmAuthEnabled = this.ntlmEnabledCheckBox.isSelected();
        this.proxyServerLabel.setEnabled(isProxyEnabled);
        this.proxyServerField.setEnabled(isProxyEnabled);
        this.proxyPortLabel.setEnabled(isProxyEnabled);
        this.proxyPortField.setEnabled(isProxyEnabled);
        this.proxyAuthEnabledCheckBox.setEnabled(isProxyEnabled);
        this.proxyUsernameLabel.setEnabled(isProxyEnabled && isProxyAuthEnabled);
        this.proxyUsernameField.setEnabled(isProxyEnabled && isProxyAuthEnabled);
        this.proxyPasswordLabel.setEnabled(isProxyEnabled && isProxyAuthEnabled);
        this.proxyPasswordField.setEnabled(isProxyEnabled && isProxyAuthEnabled);
        this.ntlmEnabledCheckBox.setEnabled(isProxyEnabled && isProxyAuthEnabled);
        this.ntlmHostLabel.setEnabled(isProxyEnabled && isProxyAuthEnabled && isNtlmAuthEnabled);
        this.ntlmHostField.setEnabled(isProxyEnabled && isProxyAuthEnabled && isNtlmAuthEnabled);
        this.ntlmDomainLabel.setEnabled(isProxyEnabled && isProxyAuthEnabled && isNtlmAuthEnabled);
        this.ntlmDomainField.setEnabled(isProxyEnabled && isProxyAuthEnabled && isNtlmAuthEnabled);
        int selectedPluginIndex = this.pluginsList.getSelectedIndex();
        this.pluginEditButton.setEnabled(selectedPluginIndex >= 0);
        this.pluginRemoveButton.setEnabled(selectedPluginIndex >= 0);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateControls();
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.setVisible(false);
            }
        };
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 0);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.define();
            }
        };
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    protected void onOk() {
        this.define();
    }

    private class PluginListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private PluginListCellRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(1, 18));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            PluginListItem item = (PluginListItem)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(item.className);
            this.setIcon(item.isValid() ? ResourceManager.VALID_ICON : ResourceManager.INVALID_ICON);
            this.setToolTipText(item.errorMessage);
            return this;
        }
    }

    private class PluginListModel
    extends DefaultListModel {
        private PluginListModel() {
        }

        public void addElement(Object obj, boolean throwErrIfRegistered) {
            PluginListItem pluginListItem = this.createItem(obj, throwErrIfRegistered);
            if (pluginListItem != null) {
                super.addElement(pluginListItem);
            }
        }

        public boolean setElement(Object obj, int index) {
            PluginListItem pluginListItem = this.createItem(obj, true);
            if (pluginListItem != null) {
                super.setElementAt(pluginListItem, index);
                this.fireContentsChanged(this, index, index);
                return true;
            }
            return false;
        }

        private PluginListItem createItem(Object obj, boolean throwErrIfRegistered) {
            String newClassName = obj.toString();
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                PluginListItem item = (PluginListItem)this.get(i);
                if (item == null || !item.className.equals(newClassName)) continue;
                if (SettingsDialog.this.isVisible()) {
                    JOptionPane.showMessageDialog(SettingsDialog.this, "Plugin is already added to the list!", "Error", 0);
                }
                return null;
            }
            String errorMessage = null;
            if (!DefinitionResolver.isPluginRegistered(newClassName) || throwErrIfRegistered) {
                try {
                    DefinitionResolver.registerPlugin(newClassName);
                }
                catch (PluginException e) {
                    errorMessage = e.getMessage();
                }
            }
            return new PluginListItem(newClassName, errorMessage);
        }
    }

    private class PluginListItem {
        String className;
        String errorMessage;

        private PluginListItem(String className, String errorMessage) {
            this.className = className;
            this.errorMessage = errorMessage;
        }

        private boolean isValid() {
            return this.errorMessage == null;
        }

        public String toString() {
            return this.className;
        }
    }
}

