/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.component.CommonDialog;
import org.webharvest.gui.component.FixedSizeButton;
import org.webharvest.gui.component.GridPanel;
import org.webharvest.utils.CommonUtil;

public class AlertDialog
extends CommonDialog {
    private Component caller;
    private int result = 2;

    public AlertDialog(String title, String message, Icon icon) {
        this(null, title, message, icon, new int[]{0}, new String[]{"OK"});
    }

    public AlertDialog(Component caller, String title, String message, Icon icon, int[] options, String[] buttLabels) {
        super(title);
        this.caller = caller;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        GridPanel gridPanel = new GridPanel();
        gridPanel.setBorder(new EmptyBorder(10, 10, 10, 20));
        String[] msgArray = CommonUtil.tokenize(message, "\n");
        for (int i = 0; i < msgArray.length; ++i) {
            gridPanel.addComponent(null, "label" + i, new JLabel(msgArray[i]), 0, i, 1, 1);
        }
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(new EmptyBorder(10, 20, 10, 10));
        contentPane.add((Component)iconLabel, "West");
        contentPane.add((Component)gridPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 3, 4));
        if (options == null || options.length == 0 || buttLabels == null || buttLabels.length != options.length) {
            options = new int[]{0};
            buttLabels = new String[]{"OK"};
        }
        for (int i = 0; i < options.length; ++i) {
            final int option = options[i];
            FixedSizeButton butt = new FixedSizeButton(buttLabels[i], 80, -1);
            butt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlertDialog.this.result = option;
                    AlertDialog.this.setVisible(false);
                }
            });
            buttonPanel.add(butt);
        }
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
    }

    protected void onOk() {
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        if (b) {
            Component relativeTo = this.caller;
            if (relativeTo == null) {
                relativeTo = GuiUtils.getActiveFrame();
            }
            if (relativeTo != null) {
                GuiUtils.centerRelativeTo(this, relativeTo);
            }
        }
        super.setVisible(b);
    }

    public int display() {
        this.setVisible(true);
        return this.result;
    }

    private String prepareMsg(String msg) {
        int maxLength = 80;
        StringBuffer result = new StringBuffer("");
        int lineLength = 0;
        if (msg != null) {
            for (int i = 0; i < msg.length(); ++i) {
                char ch = msg.charAt(i);
                if (ch == '\n' || ch == ' ' && lineLength > 80) {
                    result.append('\n');
                    lineLength = 0;
                    continue;
                }
                result.append(ch);
                ++lineLength;
            }
        }
        return result.toString();
    }
}

