/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.component.SmallButton;

public class GCPanel
extends JPanel {
    private static final Dimension PERCENT_LABEL_DIMENSION = new Dimension(80, 20);
    private static final Dimension GC_BUTTON_DIMENSION = new Dimension(20, 20);
    private PercentLabel percentLabel = new PercentLabel();

    public GCPanel(LayoutManager layout) {
        super(layout);
        this.percentLabel.setHorizontalAlignment(0);
        this.add(this.percentLabel);
        SmallButton gcButton = new SmallButton(ResourceManager.SMALL_TRASHCAN_ICON){

            public Dimension getPreferredSize() {
                return GC_BUTTON_DIMENSION;
            }
        };
        gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        gcButton.setFocusable(false);
        gcButton.setToolTipText("Run garbage collector");
        this.add(gcButton);
    }

    private long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    private long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    private double getPercentOfUsedMemory() {
        long total = this.getTotalMemory();
        long used = total - this.getFreeMemory();
        return total > 0L ? (double)used / (double)total : 1.0;
    }

    private String getUsageString() {
        long total = this.getTotalMemory();
        long used = total - this.getFreeMemory();
        return used + "M of " + total + "M";
    }

    private class PercentLabel
    extends JLabel {
        public PercentLabel() {
            this.setBackground(Color.white);
            this.setText(GCPanel.this.getUsageString());
            this.setBorder(new LineBorder(Color.gray));
            new MemoryCheckThread().start();
        }

        public Dimension getPreferredSize() {
            return PERCENT_LABEL_DIMENSION;
        }

        public void paint(Graphics g) {
            Color color = g.getColor();
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(new Color(160, 176, 228));
            int width = (int)((double)this.getWidth() * GCPanel.this.getPercentOfUsedMemory());
            g.fillRect(0, 0, width, this.getHeight());
            g.setColor(color);
            super.paint(g);
        }
    }

    private class MemoryCheckThread
    extends Thread {
        private MemoryCheckThread() {
        }

        public void run() {
            while (true) {
                this.refresh();
            }
        }

        private synchronized void refresh() {
            GCPanel.this.percentLabel.setText(GCPanel.this.getUsageString());
            GCPanel.this.percentLabel.repaint();
            try {
                MemoryCheckThread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

