/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.webharvest.exception.HttpException;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.runtime.web.HttpInfo;
import org.webharvest.runtime.web.HttpParamInfo;
import org.webharvest.runtime.web.HttpResponseWrapper;
import org.webharvest.utils.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientManager {
    public static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.1) Gecko/20060111 Firefox/1.5.0.1";
    private HttpClient client = new HttpClient();
    private HttpInfo httpInfo = new HttpInfo(this.client);

    public HttpClientManager() {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        this.client.setParams(clientParams);
    }

    public void setCookiePolicy(String cookiePolicy) {
        if ("browser".equalsIgnoreCase(cookiePolicy)) {
            this.client.getParams().setCookiePolicy("compatibility");
        } else if ("ignore".equalsIgnoreCase(cookiePolicy)) {
            this.client.getParams().setCookiePolicy("ignoreCookies");
        } else if ("netscape".equalsIgnoreCase(cookiePolicy)) {
            this.client.getParams().setCookiePolicy("netscape");
        } else if ("rfc_2109".equalsIgnoreCase(cookiePolicy)) {
            this.client.getParams().setCookiePolicy("rfc2109");
        } else {
            this.client.getParams().setCookiePolicy("default");
        }
    }

    public void setHttpProxy(String hostName, int hostPort) {
        this.client.getHostConfiguration().setProxyHost(new ProxyHost(hostName, hostPort));
    }

    public void setHttpProxy(String hostName) {
        this.client.getHostConfiguration().setProxyHost(new ProxyHost(hostName));
    }

    public void setHttpProxyCredentials(String username, String password, String host, String domain) {
        UsernamePasswordCredentials credentials = host == null || domain == null || "".equals(host.trim()) || "".equals(domain.trim()) ? new UsernamePasswordCredentials(username, password) : new NTCredentials(username, password, host, domain);
        this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
    }

    public HttpResponseWrapper execute(String methodType, boolean multipart, String url, String charset, String username, String password, Map<String, HttpParamInfo> params, Map headers) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        url = CommonUtil.encodeUrl(url, charset);
        if (username != null && password != null) {
            try {
                URL urlObj = new URL(url);
                this.client.getState().setCredentials(new AuthScope(urlObj.getHost(), urlObj.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        Object method = "post".equalsIgnoreCase(methodType) ? this.createPostMethod(url, params, multipart, charset) : this.createGetMethod(url, params, charset);
        boolean isUserAgentSpecified = false;
        if (headers != null) {
            for (String headerName : headers.keySet()) {
                if ("User-Agent".equalsIgnoreCase(headerName)) {
                    isUserAgentSpecified = true;
                }
                String headerValue = (String)headers.get(headerName);
                method.addRequestHeader(new Header(headerName, headerValue));
            }
        }
        if (!isUserAgentSpecified) {
            this.identifyAsDefaultBrowser((HttpMethodBase)method);
        }
        try {
            String newURI;
            Header header;
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (!(statusCode != 302 && statusCode != 301 && statusCode != 303 && statusCode != 307 || (header = method.getResponseHeader("location")) == null || CommonUtil.isEmptyString(newURI = header.getValue()))) {
                method.releaseConnection();
                method = new GetMethod(CommonUtil.fullUrl(url, newURI));
                this.identifyAsDefaultBrowser((HttpMethodBase)method);
                this.client.executeMethod((HttpMethod)method);
            }
            HttpResponseWrapper httpResponseWrapper = new HttpResponseWrapper((HttpMethodBase)method);
            this.httpInfo.setResponse(httpResponseWrapper);
            HttpResponseWrapper httpResponseWrapper2 = httpResponseWrapper;
            return httpResponseWrapper2;
        }
        catch (IOException e) {
            throw new HttpException("IO error during HTTP execution for URL: " + url, e);
        }
        finally {
            method.releaseConnection();
        }
    }

    private void identifyAsDefaultBrowser(HttpMethodBase method) {
        method.addRequestHeader(new Header("User-Agent", DEFAULT_USER_AGENT));
    }

    private HttpMethodBase createPostMethod(String url, Map<String, HttpParamInfo> params, boolean multipart, String charset) {
        PostMethod method = new PostMethod(url);
        int filenameIndex = 1;
        if (params != null) {
            if (multipart) {
                Part[] parts = new Part[params.size()];
                int index = 0;
                for (Map.Entry<String, HttpParamInfo> entry : params.entrySet()) {
                    String name = entry.getKey();
                    HttpParamInfo httpParamInfo = entry.getValue();
                    Variable value = httpParamInfo.getValue();
                    if (httpParamInfo.isFile()) {
                        String contentType;
                        String filename = httpParamInfo.getFileName();
                        if (CommonUtil.isEmptyString(filename)) {
                            filename = "uploadedfile_" + filenameIndex;
                            ++filenameIndex;
                        }
                        if (CommonUtil.isEmptyString(contentType = httpParamInfo.getContentType())) {
                            contentType = null;
                        }
                        byte[] bytes = value.toBinary(charset);
                        parts[index] = new FilePart(httpParamInfo.getName(), (PartSource)new ByteArrayPartSource(filename, bytes), contentType, charset);
                    } else {
                        parts[index] = new StringPart(name, CommonUtil.nvl(value, ""), charset);
                    }
                    ++index;
                }
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            } else {
                NameValuePair[] paramArray = new NameValuePair[params.size()];
                int index = 0;
                for (Map.Entry<String, HttpParamInfo> entry : params.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue().getValue().toString();
                    paramArray[index++] = new NameValuePair(name, value);
                }
                method.setRequestBody(paramArray);
            }
        }
        return method;
    }

    private GetMethod createGetMethod(String url, Map<String, HttpParamInfo> params, String charset) {
        if (params != null) {
            String urlParams = "";
            for (Map.Entry<String, HttpParamInfo> entry : params.entrySet()) {
                String value = entry.getValue().toString();
                NameValuePair pair = new NameValuePair(entry.getKey(), value);
                try {
                    urlParams = urlParams + pair.getName() + "=" + URLEncoder.encode(value == null ? "" : value, charset) + "&";
                }
                catch (UnsupportedEncodingException e) {
                    throw new HttpException("Charset " + charset + " is not supported!", e);
                }
            }
            if (!"".equals(urlParams)) {
                url = url.indexOf("?") < 0 ? url + "?" + urlParams : (url.endsWith("&") ? url + urlParams : url + "&" + urlParams);
            }
        }
        return new GetMethod(url);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public HttpInfo getHttpInfo() {
        return this.httpInfo;
    }

    static {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
    }
}

