/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import org.bounce.text.xml.XmlParserUtils;

public class XMLDocument
extends PlainDocument {
    private static final long serialVersionUID = 3256723974510424372L;
    public static final String TAG_COMPLETION_ATTRIBUTE = "tagCompletion";
    public static final String AUTO_INDENTATION_ATTRIBUTE = "autoIndentation";
    static final String LOADING_ATTRIBUTE = "loading";
    private JEditorPane editor = null;

    public XMLDocument(JEditorPane editor) {
        super(new GapContent(1024));
        this.editor = editor;
    }

    private boolean isLoading() {
        Boolean loading = (Boolean)this.getProperty(LOADING_ATTRIBUTE);
        if (loading != null) {
            return loading;
        }
        return false;
    }

    private boolean isAutoIndentation() {
        Boolean autoIndentation = (Boolean)this.getProperty(AUTO_INDENTATION_ATTRIBUTE);
        if (autoIndentation != null && !this.isLoading()) {
            return autoIndentation;
        }
        return false;
    }

    private boolean isTagCompletion() {
        Boolean tagCompletion = (Boolean)this.getProperty(TAG_COMPLETION_ATTRIBUTE);
        if (tagCompletion != null && !this.isLoading()) {
            return tagCompletion;
        }
        return false;
    }

    public void insertString(int off, String str, AttributeSet set) throws BadLocationException {
        if (str.equals(">") && this.isTagCompletion()) {
            String tag;
            char first;
            int dot = this.editor.getCaret().getDot();
            StringBuffer endTag = new StringBuffer(str);
            String text = this.getText(0, off);
            int startTag = text.lastIndexOf(60, off);
            int prefEndTag = text.lastIndexOf(62, off);
            if (startTag > 0 && startTag > prefEndTag && startTag < text.length() - 1 && (first = (tag = text.substring(startTag, text.length())).charAt(1)) != '/' && first != '!' && first != '?' && !Character.isWhitespace(first)) {
                boolean finished = false;
                char previous = tag.charAt(tag.length() - 1);
                if (previous != '/' && previous != '-') {
                    endTag.append("</");
                    for (int i = 1; i < tag.length() && !finished; ++i) {
                        char ch = tag.charAt(i);
                        if (!Character.isWhitespace(ch)) {
                            endTag.append(ch);
                            continue;
                        }
                        finished = true;
                    }
                    endTag.append(">");
                }
            }
            str = endTag.toString();
            super.insertString(off, str, set);
            this.editor.getCaret().setDot(dot + 1);
        } else if (str.equals("\n") && this.isAutoIndentation()) {
            String remainingText;
            StringBuffer newStr = new StringBuffer(str);
            Element elem = this.getDefaultRootElement().getElement(this.getDefaultRootElement().getElementIndex(off));
            int start = elem.getStartOffset();
            int end = elem.getEndOffset();
            String line = this.getText(start, off - start);
            boolean finished = false;
            for (int i = 0; i < line.length() && !finished; ++i) {
                char ch = line.charAt(i);
                if (ch != '\n' && ch != '\f' && ch != '\r' && Character.isWhitespace(ch)) {
                    newStr.append(ch);
                    continue;
                }
                finished = true;
            }
            String elementName = XmlParserUtils.getStartElement(line);
            if (!(elementName == null || (remainingText = this.getText(off, end - off - 1)) != null && remainingText.trim().startsWith("</" + elementName + ">"))) {
                newStr.append("\t");
            }
            str = newStr.toString();
            super.insertString(off, str, set);
        } else {
            super.insertString(off, str, set);
        }
    }
}

