/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.io.IOException;
import javax.swing.text.Document;
import org.bounce.text.xml.XMLInputReader;
import org.bounce.text.xml.XMLInputStream;

public class XMLScanner {
    private Scanner tagScanner = null;
    private final AttributeScanner ATTRIBUTE_SCANNER = new AttributeScanner();
    private final ElementEndTagScanner ELEMENT_END_TAG_SCANNER = new ElementEndTagScanner();
    private final ElementStartTagScanner ELEMENT_START_TAG_SCANNER = new ElementStartTagScanner();
    private final ElementNameScanner ELEMENT_NAME_SCANNER = new ElementNameScanner();
    private final EntityTagScanner ENTITY_TAG_SCANNER = new EntityTagScanner();
    private final CommentScanner COMMENT_SCANNER = new CommentScanner();
    private final CDataScanner CDATA_SCANNER = new CDataScanner();
    private final TagScanner TAG_SCANNER = new TagScanner();
    private int start = 0;
    private long pos = 0L;
    private XMLInputReader in = null;
    private boolean valid = false;
    public String token = null;

    public XMLScanner(Document document) throws IOException {
        try {
            this.in = new XMLInputReader(new XMLInputStream(document));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.in.read();
        this.scan();
    }

    boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setRange(int start, int end) throws IOException {
        this.in.setRange(start, end);
        this.start = start;
        this.token = null;
        this.pos = 0L;
        this.tagScanner = null;
        this.in.read();
        this.scan();
    }

    public final int getStartOffset() {
        int begOffs = (int)this.pos;
        return this.start + begOffs;
    }

    public final int getEndOffset() {
        int endOffs = (int)this.in.pos;
        return this.start + endOffs;
    }

    public long scan() throws IOException {
        long l = this.pos;
        if (this.tagScanner != null) {
            this.token = this.tagScanner.scan(this.in);
            if (this.tagScanner.isFinished()) {
                this.tagScanner = null;
            }
            return l;
        }
        this.pos = this.in.pos;
        int ch = this.in.getLastChar();
        switch (ch) {
            case -1: {
                this.token = null;
                return l;
            }
            case 60: {
                ch = this.in.read();
                this.tagScanner = this.TAG_SCANNER;
                this.tagScanner.reset();
                this.token = this.tagScanner.scan(this.in);
                return l;
            }
        }
        this.scanValue();
        this.token = "element-value";
        return l;
    }

    private void scanValue() throws IOException {
        int ch = this.in.read();
        while (true) {
            switch (ch) {
                case -1: {
                    return;
                }
                case 60: {
                    return;
                }
            }
            ch = this.in.read();
        }
    }

    private void skipWhitespace() throws IOException {
        int ch = this.in.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.in.read();
        }
    }

    private void scanString(int end) throws IOException {
        int ch = this.in.read();
        while (ch != end && ch != 62 && ch != -1) {
            ch = this.in.read();
        }
    }

    abstract class Scanner {
        protected int token = -1;
        private boolean finished = false;

        Scanner() {
        }

        public abstract String scan(XMLInputReader var1) throws IOException;

        protected void setFinished(boolean isFinished) {
            this.finished = isFinished;
        }

        protected void setFinished() {
            this.setFinished(true);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void reset() {
            this.finished = false;
            this.token = -1;
        }

        public int getToken() {
            return this.token;
        }
    }

    private class AttributeScanner
    extends Scanner {
        private final int NAME = 0;
        private final int VALUE = 1;
        private final int END = 2;
        private int mode = 0;
        private boolean hasPrefix = false;
        private boolean firstTime = true;
        private boolean isNamespace = false;

        private AttributeScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            int character = in.getLastChar();
            while (true) {
                if (this.mode == 0) {
                    switch (character) {
                        case -1: {
                            this.setFinished();
                            return "attribute-name";
                        }
                        case 120: {
                            if (this.firstTime) {
                                character = in.read();
                                if (character != 109 || (character = in.read()) != 108 || (character = in.read()) != 110 || (character = in.read()) != 115) break;
                                XMLScanner.this.skipWhitespace();
                                character = in.getLastChar();
                                if (character != 58 && character != 61) break;
                                this.isNamespace = true;
                                break;
                            }
                            character = in.read();
                            break;
                        }
                        case 58: {
                            if (this.hasPrefix) {
                                character = in.read();
                                return "Special";
                            }
                            if (this.isNamespace) {
                                this.hasPrefix = true;
                                return "namespace-name";
                            }
                            this.hasPrefix = true;
                            return "attribute-prefix";
                        }
                        case 62: {
                            this.setFinished();
                            return "Special";
                        }
                        case 61: {
                            this.mode = 1;
                            if (this.isNamespace && this.hasPrefix) {
                                return "namespace-prefix";
                            }
                            if (this.isNamespace) {
                                return "namespace-name";
                            }
                            return "attribute-name";
                        }
                        default: {
                            character = in.read();
                        }
                    }
                    this.firstTime = false;
                    continue;
                }
                if (this.mode != 1) continue;
                switch (character) {
                    case -1: {
                        return null;
                    }
                    case 61: {
                        character = in.read();
                        return "Special";
                    }
                    case 34: 
                    case 39: {
                        XMLScanner.this.scanString(character);
                        XMLScanner.this.skipWhitespace();
                        if (this.isNamespace) {
                            this.reset();
                            return "namespace-value";
                        }
                        this.reset();
                        return "attribute-value";
                    }
                    case 62: {
                        character = in.read();
                        this.setFinished();
                        return "Special";
                    }
                }
                character = in.read();
            }
        }

        public void reset() {
            super.reset();
            this.mode = 0;
            this.hasPrefix = false;
            this.firstTime = true;
            this.isNamespace = false;
        }
    }

    private class ElementNameScanner
    extends Scanner {
        private boolean hasPrefix = false;
        private boolean emptyElement = false;

        private ElementNameScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            int character = in.getLastChar();
            while (true) {
                switch (character) {
                    case -1: {
                        this.setFinished();
                        return "element-name";
                    }
                    case 58: {
                        if (this.hasPrefix) {
                            character = in.read();
                            return "Special";
                        }
                        this.hasPrefix = true;
                        return "element-prefix";
                    }
                    case 47: {
                        if (this.emptyElement) {
                            character = in.read();
                        } else {
                            this.emptyElement = true;
                            return "element-name";
                        }
                    }
                    case 62: {
                        this.setFinished();
                        if (this.emptyElement) {
                            return "Special";
                        }
                        return "element-name";
                    }
                    case 10: 
                    case 13: 
                    case 32: {
                        XMLScanner.this.skipWhitespace();
                        this.setFinished();
                        return "element-name";
                    }
                }
                character = in.read();
            }
        }

        public void reset() {
            super.reset();
            this.emptyElement = false;
            this.hasPrefix = false;
        }
    }

    private class ElementStartTagScanner
    extends Scanner {
        private Scanner scanner = null;

        private ElementStartTagScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            String token = null;
            if (this.scanner == null) {
                this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
                this.scanner.reset();
                token = this.scanner.scan(in);
            } else {
                token = this.scanner.scan(in);
            }
            if (this.scanner.isFinished()) {
                if (this.scanner instanceof ElementNameScanner) {
                    this.scanner = XMLScanner.this.ATTRIBUTE_SCANNER;
                    this.scanner.reset();
                } else {
                    this.setFinished();
                }
            }
            return token;
        }

        public void reset() {
            super.reset();
            this.scanner = null;
        }
    }

    private class ElementEndTagScanner
    extends Scanner {
        private Scanner scanner = null;

        private ElementEndTagScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            if (this.scanner == null) {
                this.scanner = XMLScanner.this.ELEMENT_NAME_SCANNER;
                this.scanner.reset();
            }
            String token = this.scanner.scan(in);
            if (this.scanner.isFinished()) {
                this.setFinished();
            }
            return token;
        }

        public void reset() {
            super.reset();
            this.scanner = null;
        }
    }

    private class CDataScanner
    extends Scanner {
        private CDataScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            int character = in.read();
            block4: while (true) {
                switch (character) {
                    case -1: {
                        this.setFinished();
                        return "CData";
                    }
                    case 93: {
                        boolean isCDataEnd = in.startsWith("]>");
                        if (isCDataEnd) {
                            this.setFinished();
                            return "CData";
                        }
                        character = in.getLastChar();
                        continue block4;
                    }
                }
                character = in.read();
            }
        }

        public void reset() {
            super.reset();
        }
    }

    private class CommentScanner
    extends Scanner {
        private CommentScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            int character = in.read();
            block4: while (true) {
                switch (character) {
                    case -1: {
                        this.setFinished();
                        return "Comment";
                    }
                    case 45: {
                        boolean isCommentEnd = in.startsWith("->");
                        character = in.getLastChar();
                        if (!isCommentEnd) continue block4;
                        this.setFinished();
                        return "Comment";
                    }
                }
                character = in.read();
            }
        }

        public void reset() {
            super.reset();
        }
    }

    private class EntityTagScanner
    extends Scanner {
        private EntityTagScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            int character = in.read();
            while (true) {
                switch (character) {
                    case -1: {
                        this.setFinished();
                        return "Entity";
                    }
                    case 62: {
                        this.setFinished();
                        return "Entity";
                    }
                }
                character = in.read();
            }
        }

        public void reset() {
            super.reset();
        }
    }

    private class TagScanner
    extends Scanner {
        private Scanner scanner = null;

        private TagScanner() {
        }

        public String scan(XMLInputReader in) throws IOException {
            if (this.scanner != null) {
                String token = this.scanner.scan(in);
                if (this.scanner.isFinished()) {
                    this.scanner = null;
                }
                return token;
            }
            int character = in.getLastChar();
            if (character == 33) {
                character = in.read();
                if (character == 45) {
                    character = in.read();
                    if (character == 45) {
                        this.scanner = XMLScanner.this.COMMENT_SCANNER;
                        character = in.read();
                    }
                } else {
                    boolean isCDataStart = in.startsWith(character, "[CDATA[");
                    character = in.getLastChar();
                    if (isCDataStart) {
                        this.scanner = XMLScanner.this.CDATA_SCANNER;
                        character = in.read();
                    }
                }
                if (this.scanner == null) {
                    this.scanner = XMLScanner.this.ENTITY_TAG_SCANNER;
                }
                this.scanner.reset();
                return "Special";
            }
            if (character == 63) {
                character = in.read();
                this.scanner = XMLScanner.this.ENTITY_TAG_SCANNER;
                this.scanner.reset();
                return "Special";
            }
            if (character == 47) {
                character = in.read();
                this.scanner = XMLScanner.this.ELEMENT_END_TAG_SCANNER;
                this.scanner.reset();
                return "Special";
            }
            if (character == 62) {
                character = in.read();
                this.setFinished();
                return "Special";
            }
            this.scanner = XMLScanner.this.ELEMENT_START_TAG_SCANNER;
            this.scanner.reset();
            return "Special";
        }

        public void reset() {
            super.reset();
            this.scanner = null;
        }
    }
}

