/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.webharvest.definition.XmlNode;
import org.webharvest.definition.XmlParser;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.ResourceManager;
import org.webharvest.gui.component.ProportionalSplitPane;
import org.webharvest.gui.component.WHScrollPane;
import org.webharvest.utils.CommonUtil;
import org.xml.sax.InputSource;

public class HelpFrame
extends JFrame
implements TreeSelectionListener {
    private static final Dimension HELP_FRAME_DIMENSION = new Dimension(750, 500);
    private JEditorPane htmlPane;
    private JTree tree;
    private DefaultMutableTreeNode topNode;
    private DefaultTreeModel treeModel;

    public HelpFrame() {
        this.setTitle("Web-Harvest Help");
        this.setIconImage(((ImageIcon)ResourceManager.HELP32_ICON).getImage());
        this.topNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.topNode);
        try {
            String helpContent = CommonUtil.readStringFromUrl(ResourceManager.getHelpContentUrl());
            XmlNode xmlNode = XmlParser.parse(new InputSource(new StringReader(helpContent)));
            this.createNodes(this.topNode, xmlNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtils.showErrorMessage("Error reading help content!");
        }
        this.tree = new JTree(this.topNode);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object userObject;
                DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = (defaultMutableTreeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof TopicInfo) {
                    TopicInfo topicInfo = (TopicInfo)userObject;
                    renderer.setIcon(topicInfo.subtopicCount == 0 ? ResourceManager.HELPTOPIC_ICON : ResourceManager.HELPDIR_ICON);
                }
                return renderer;
            }
        });
        this.tree.addTreeSelectionListener(this);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        ProportionalSplitPane splitPane = new ProportionalSplitPane(1);
        splitPane.setResizeWeight(0.0);
        splitPane.setBorder(null);
        WHScrollPane treeScrollPane = new WHScrollPane(this.tree);
        treeScrollPane.getViewport().setBackground(Color.white);
        treeScrollPane.setBackground(Color.white);
        splitPane.setLeftComponent(treeScrollPane);
        splitPane.setRightComponent(new WHScrollPane(this.htmlPane));
        ((JSplitPane)splitPane).setDividerLocation(0.3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)splitPane, "Center");
        this.pack();
    }

    private void createNodes(DefaultMutableTreeNode root, XmlNode xmlNode) {
        Object topicsObject;
        if (xmlNode != null && (topicsObject = xmlNode.getElement("topic")) instanceof List) {
            List subtopics = (List)topicsObject;
            for (int i = 0; i < subtopics.size(); ++i) {
                XmlNode xmlSubNode = (XmlNode)subtopics.get(i);
                String id = xmlSubNode.getAttribute("id");
                String title = xmlSubNode.getAttribute("title");
                Object subs = xmlSubNode.getElement("topic");
                int subtopicCount = subs instanceof List ? ((List)subs).size() : 0;
                TopicInfo topicInfo = new TopicInfo(id, title, subtopicCount);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(topicInfo);
                this.treeModel.insertNodeInto(node, root, root.getChildCount());
                this.createNodes(node, xmlSubNode);
            }
        }
    }

    public Dimension getPreferredSize() {
        return HELP_FRAME_DIMENSION;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof TopicInfo) {
            TopicInfo topicInfo = (TopicInfo)userObject;
            try {
                if (topicInfo.subtopicCount > 0) {
                    this.htmlPane.setText("<div style='font-family:Verdana,Tahoma;font-size:10px;'>Please choose a topic</div>");
                    return;
                }
                URL helpFileUrl = ResourceManager.getHelpFileUrl(topicInfo.id);
                if (helpFileUrl == null) {
                    throw new RuntimeException();
                }
                String content = CommonUtil.readStringFromUrl(helpFileUrl);
                content = "<html><body style=\"font-family:Verdana,Tahoma;font-size:10px;\"><h2>" + topicInfo.title + "</h2>" + content + "</body></html>";
                ((HTMLDocument)this.htmlPane.getDocument()).setBase(helpFileUrl);
                this.htmlPane.setText(content);
                this.htmlPane.setCaretPosition(0);
            }
            catch (Exception e1) {
                this.htmlPane.setText("<div style='color:#FF0000;font-family:Verdana,Tahoma;font-size:10px;'>Cannot read help for \"" + topicInfo.title + "\"!</div>");
            }
        }
    }

    private class TopicInfo {
        private String id;
        private String title;
        private int subtopicCount;

        public TopicInfo(String id, String title, int subtopicCount) {
            this.id = id;
            this.title = title;
            this.subtopicCount = subtopicCount;
        }

        public String toString() {
            return this.title;
        }
    }
}

