/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.webharvest.gui.TreeNodeInfo;

public class NodeRenderer
extends DefaultTreeCellRenderer {
    public static final Color RUNNING_BG_COLOR = new Color(126, 214, 131);
    public static final Color EXECUTED_COLOR = new Color(0, 128, 0);
    public static final Color EXCEPTION_COLOR = Color.white;
    public static final Color EXCEPTION_BG_COLOR = Color.red;
    private TreeNodeInfo executingNodeInfo;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object userObject;
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode && (userObject = (defaultMutableTreeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof TreeNodeInfo) {
            TreeNodeInfo treeNodeInfo = (TreeNodeInfo)userObject;
            renderer.setToolTipText(null);
            if (treeNodeInfo.hasException()) {
                renderer.setForeground(EXCEPTION_COLOR);
                renderer.setBackgroundNonSelectionColor(EXCEPTION_BG_COLOR);
                String msg = treeNodeInfo.getException().getMessage();
                renderer.setToolTipText(msg == null ? "Error" : msg);
            } else {
                renderer.setBackgroundNonSelectionColor(this.executingNodeInfo == treeNodeInfo ? RUNNING_BG_COLOR : Color.white);
                if (!sel && this.executingNodeInfo != treeNodeInfo && treeNodeInfo.getExecutionCount() > 0) {
                    renderer.setForeground(EXECUTED_COLOR);
                }
            }
            Icon icon = treeNodeInfo.getIcon();
            if (icon != null) {
                renderer.setIcon(icon);
            }
        }
        return renderer;
    }

    public TreeNodeInfo getExecutingNodeInfo() {
        return this.executingNodeInfo;
    }

    public void setExecutingNodeInfo(TreeNodeInfo executingNodeInfo) {
        this.executingNodeInfo = executingNodeInfo;
    }

    public void markException(Exception e) {
        if (this.executingNodeInfo != null) {
            this.executingNodeInfo.setException(e);
        }
    }
}

