/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.component.FixedSizeButton;

public abstract class CommonDialog
extends JDialog {
    private Map components = new HashMap();
    private DefaultKeyboardFocusManager keyManager;
    private Component lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();

    public CommonDialog() {
        super(GuiUtils.getActiveFrame());
        this.setResizable(false);
        this.setModal(true);
        this.keyManager = new DefaultKeyboardFocusManager(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401) {
                    int keyCode = e.getKeyCode();
                    Object source = e.getSource();
                    if (keyCode == 27 || keyCode == 10) {
                        JComboBox comboBox;
                        if (source instanceof JTextArea && keyCode == 10) {
                            return false;
                        }
                        JComboBox jComboBox = comboBox = source instanceof Component ? CommonDialog.this.getParentComboBox((Component)source) : null;
                        if (comboBox != null && comboBox.isPopupVisible()) {
                            return false;
                        }
                        if (CommonDialog.this.isActive()) {
                            if (keyCode == 27) {
                                CommonDialog.this.onCancel();
                                return true;
                            }
                            CommonDialog.this.onOk();
                        }
                    }
                }
                return false;
            }
        };
    }

    private JComboBox getParentComboBox(Component comp) {
        do {
            if (!(comp instanceof JComboBox)) continue;
            return (JComboBox)comp;
        } while ((comp = comp.getParent()) != null);
        return null;
    }

    public CommonDialog(String title) {
        this();
        this.setTitle(title);
    }

    public void setVisible(boolean b) {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (b) {
            keyboardFocusManager.addKeyEventDispatcher(this.keyManager);
        } else {
            keyboardFocusManager.removeKeyEventDispatcher(this.keyManager);
        }
        super.setVisible(b);
        Window owner = this.getOwner();
        if (owner != null) {
            owner.requestFocus();
            if (this.lastFocusOwner != null) {
                this.lastFocusOwner.requestFocusInWindow();
            }
        }
    }

    protected JButton createOkButton() {
        FixedSizeButton okButton = new FixedSizeButton("OK", 80, -1);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonDialog.this.onOk();
            }
        });
        return okButton;
    }

    protected JButton createCancelButton() {
        FixedSizeButton cancelButton = new FixedSizeButton("Cancel", 80, -1);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonDialog.this.onCancel();
            }
        });
        return cancelButton;
    }

    protected void onCancel() {
        this.setVisible(false);
    }

    protected abstract void onOk();

    public void addComponent(String id, Component comp) {
        if (id != null) {
            this.components.put(id, comp);
        }
    }

    public Component getComponent(String id) {
        return id != null ? (Component)this.components.get(id) : null;
    }

    public Object getComponentValue(String componentId) {
        Object comp = this.components.get(componentId);
        if (comp != null) {
            if (comp instanceof JTextComponent) {
                return ((JTextComponent)comp).getText();
            }
            if (comp instanceof JComboBox) {
                return ((JComboBox)comp).getSelectedItem();
            }
        }
        return null;
    }

    public boolean getBooleanValue(String componentId) {
        Object comp = this.components.get(componentId);
        if (comp != null) {
            if (comp instanceof JRadioButton) {
                return ((JRadioButton)comp).isSelected();
            }
            if (comp instanceof JCheckBox) {
                return ((JCheckBox)comp).isSelected();
            }
        }
        return false;
    }

    public JTextField getTextField(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JTextField ? (JTextField)comp : null;
    }

    public JTextArea getTextArea(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JTextArea ? (JTextArea)comp : null;
    }

    public JComboBox getComboBox(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JComboBox ? (JComboBox)comp : null;
    }

    public JList getList(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JList ? (JList)comp : null;
    }

    public JCheckBox getCheckBox(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JCheckBox ? (JCheckBox)comp : null;
    }

    public JRadioButton getRadioButton(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JRadioButton ? (JRadioButton)comp : null;
    }

    public JLabel getLabel(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JLabel ? (JLabel)comp : null;
    }

    public JButton getButton(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JButton ? (JButton)comp : null;
    }

    public JSlider getSlider(String name) {
        Object comp = this.components.get(name);
        return comp instanceof JSlider ? (JSlider)comp : null;
    }
}

