/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.util.ArrayList;
import org.webharvest.definition.WhileDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BaseProcessor;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.scripting.ScriptEngine;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class WhileProcessor
extends BaseProcessor {
    private WhileDef whileDef;

    public WhileProcessor(WhileDef whileDef) {
        super(whileDef);
        this.whileDef = whileDef;
    }

    public Variable execute(Scraper scraper, ScraperContext context) {
        ScriptEngine scriptEngine = scraper.getScriptEngine();
        String index = BaseTemplater.execute(this.whileDef.getIndex(), scriptEngine);
        String maxLoopsString = BaseTemplater.execute(this.whileDef.getMaxLoops(), scriptEngine);
        boolean isEmpty = CommonUtil.getBooleanValue(BaseTemplater.execute(this.whileDef.getEmpty(), scriptEngine), false);
        double maxLoops = 1.0E9;
        if (maxLoopsString != null && !"".equals(maxLoopsString.trim())) {
            maxLoops = Double.parseDouble(maxLoopsString);
        }
        ArrayList resultList = new ArrayList();
        Variable indexBeforeLoop = (Variable)context.get(index);
        int i = 1;
        if (index != null && !"".equals(index)) {
            context.put(index, new NodeVariable(String.valueOf(i)));
        }
        String condition = BaseTemplater.execute(this.whileDef.getCondition(), scriptEngine);
        this.setProperty("Condition", condition);
        this.setProperty("Index", index);
        this.setProperty("Max Loops", maxLoopsString);
        this.setProperty("Empty", String.valueOf(isEmpty));
        while (CommonUtil.isBooleanTrue(condition) && (double)i <= maxLoops) {
            Variable loopResult = new BodyProcessor(this.whileDef).execute(scraper, context);
            if (!isEmpty) {
                resultList.addAll(loopResult.toList());
            }
            ++i;
            if (index != null && !"".equals(index)) {
                context.put(index, new NodeVariable(String.valueOf(i)));
            }
            condition = BaseTemplater.execute(this.whileDef.getCondition(), scriptEngine);
        }
        if (index != null && indexBeforeLoop != null) {
            context.put(index, indexBeforeLoop);
        }
        return isEmpty ? new EmptyVariable() : new ListVariable(resultList);
    }
}

