/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.webharvest.exception.DatabaseException;
import org.webharvest.exception.PluginException;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.DbColumnDescription;
import org.webharvest.runtime.processors.plugins.DbParamPlugin;
import org.webharvest.runtime.processors.plugins.DbRowVariable;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.Variable;

public class DatabasePlugin
extends WebHarvestPlugin {
    private List<DbParamInfo> dbParams = null;

    public String getName() {
        return "database";
    }

    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        String jdbc = this.evaluateAttribute("jdbcclass", scraper);
        String connection = this.evaluateAttribute("connection", scraper);
        String username = this.evaluateAttribute("username", scraper);
        String password = this.evaluateAttribute("password", scraper);
        int maxRows = this.evaluateAttributeAsInteger("max", -1, scraper);
        boolean isAutoCommit = this.evaluateAttributeAsBoolean("autocommit", true, scraper);
        Connection conn = scraper.getConnection(jdbc, connection, username, password);
        Variable body = this.executeBody(scraper, context);
        String sql = body.toString();
        try {
            conn.setAutoCommit(isAutoCommit);
            PreparedStatement statement = conn.prepareStatement(sql, 1004, 1007);
            int index = 1;
            if (this.dbParams != null) {
                for (DbParamInfo paramInfo : this.dbParams) {
                    if ("int".equalsIgnoreCase(paramInfo.type)) {
                        try {
                            int intValue = Integer.parseInt(paramInfo.value.toString());
                            statement.setInt(index, intValue);
                        }
                        catch (NumberFormatException e) {
                            throw new PluginException("Error in SQL statement - invalid integer!", e);
                        }
                    } else if ("long".equalsIgnoreCase(paramInfo.type)) {
                        try {
                            long longValue = Long.parseLong(paramInfo.value.toString());
                            statement.setLong(index, longValue);
                        }
                        catch (NumberFormatException e) {
                            throw new PluginException("Error in SQL statement - invalid long!", e);
                        }
                    } else if ("double".equalsIgnoreCase(paramInfo.type)) {
                        try {
                            double doubleValue = Double.parseDouble(paramInfo.value.toString());
                            statement.setDouble(index, doubleValue);
                        }
                        catch (NumberFormatException e) {
                            throw new PluginException("Error in SQL statement - invalid long!", e);
                        }
                    } else if ("binary".equalsIgnoreCase(paramInfo.type)) {
                        statement.setBytes(index, paramInfo.value.toBinary());
                    } else {
                        statement.setString(index, paramInfo.value.toString());
                    }
                    ++index;
                }
            }
            statement.execute();
            ResultSet resultSet = statement.getResultSet();
            if (resultSet != null) {
                ResultSetMetaData metadata = resultSet.getMetaData();
                ListVariable queryResult = new ListVariable();
                int columnCount = metadata.getColumnCount();
                DbColumnDescription[] colDescs = new DbColumnDescription[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    String colName = metadata.getColumnLabel(i);
                    int colType = metadata.getColumnType(i);
                    colDescs[i - 1] = new DbColumnDescription(colName, colType);
                }
                for (int rowCount = 0; resultSet.next() && (maxRows < 0 || rowCount < maxRows); ++rowCount) {
                    Object[] rowData = new Object[columnCount];
                    block17: for (int i = 0; i < columnCount; ++i) {
                        switch (colDescs[i].getType()) {
                            case 6: {
                                rowData[i] = Float.valueOf(resultSet.getFloat(i + 1));
                                continue block17;
                            }
                            case 2: 
                            case 3: 
                            case 7: 
                            case 8: {
                                rowData[i] = resultSet.getDouble(i + 1);
                                continue block17;
                            }
                            case -6: 
                            case 4: 
                            case 5: {
                                rowData[i] = resultSet.getInt(i + 1);
                                continue block17;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                rowData[i] = resultSet.getBytes(i + 1);
                                continue block17;
                            }
                            default: {
                                rowData[i] = resultSet.getString(i + 1);
                            }
                        }
                    }
                    queryResult.addVariable(new DbRowVariable(colDescs, rowData));
                }
                return queryResult;
            }
            return new EmptyVariable();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    public String[] getValidAttributes() {
        return new String[]{"jdbcclass", "connection", "username", "password", "max", "autocommit"};
    }

    public String[] getRequiredAttributes() {
        return new String[]{"jdbcclass", "connection"};
    }

    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("output".equalsIgnoreCase(attributeName)) {
            return new String[]{"text", "xml"};
        }
        if ("autocommit".equalsIgnoreCase(attributeName)) {
            return new String[]{"true", "false"};
        }
        return null;
    }

    public Class[] getDependantProcessors() {
        return new Class[]{DbParamPlugin.class};
    }

    void addDbParam(Variable value, String type) {
        if (this.dbParams == null) {
            this.dbParams = new ArrayList<DbParamInfo>();
        }
        this.dbParams.add(new DbParamInfo(value, type));
    }

    private class DbParamInfo {
        private Variable value;
        private String type;

        private DbParamInfo(Variable value, String type) {
            this.value = value;
            this.type = type;
        }
    }
}

