/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors.plugins;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.WebHarvestPlugin;
import org.webharvest.runtime.processors.plugins.ZipPlugin;
import org.webharvest.runtime.processors.plugins.ZipPluginException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;

public class ZipEntryPlugin
extends WebHarvestPlugin {
    public String getName() {
        return "zip-entry";
    }

    public Variable executePlugin(Scraper scraper, ScraperContext context) {
        ZipPlugin zipPlugin = (ZipPlugin)scraper.getRunningProcessorOfType(ZipPlugin.class);
        if (zipPlugin != null) {
            String name = this.evaluateAttribute("name", scraper);
            if (CommonUtil.isEmptyString(name)) {
                throw new ZipPluginException("Name of zip entry cannot be empty!");
            }
            String charset = this.evaluateAttribute("charset", scraper);
            if (CommonUtil.isEmptyString(charset)) {
                charset = scraper.getConfiguration().getCharset();
            }
            ZipOutputStream zipOutStream = zipPlugin.getZipOutStream();
            Variable bodyResult = this.executeBody(scraper, context);
            try {
                zipOutStream.putNextEntry(new ZipEntry(name));
                zipOutStream.write(bodyResult.toBinary(charset));
                zipOutStream.closeEntry();
            }
            catch (IOException e) {
                throw new ZipPluginException(e);
            }
        } else {
            throw new ZipPluginException("Cannot use zip entry plugin out of zip plugin context!");
        }
        return new EmptyVariable();
    }

    public String[] getValidAttributes() {
        return new String[]{"name", "charset"};
    }

    public String[] getRequiredAttributes() {
        return new String[]{"name"};
    }

    public String[] getAttributeValueSuggestions(String attributeName) {
        if ("charset".equalsIgnoreCase(attributeName)) {
            Set<String> charsetKeys = Charset.availableCharsets().keySet();
            return new ArrayList<String>(charsetKeys).toArray(new String[charsetKeys.size()]);
        }
        return null;
    }
}

