/*
 * Decompiled with CFR 0.152.
 */
package wvlet.surface.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;
import wvlet.surface.ArraySurface;
import wvlet.surface.Surface;
import wvlet.surface.reflect.ReflectTypeUtil$;

public final class ReflectTypeUtil$
implements LogSupport {
    public static final ReflectTypeUtil$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ReflectTypeUtil$();
    }

    private Logger logger$lzycompute() {
        ReflectTypeUtil$ reflectTypeUtil$ = this;
        synchronized (reflectTypeUtil$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.class.logger((LazyLogger)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <A> Class<?> cls(A obj) {
        return obj.getClass();
    }

    public <A> Option<Object> companionObject(Class<A> cl) {
        None$ none$;
        try {
            String clName = cl.getName();
            Class<A> companionCls = clName.endsWith("$") ? cl : Class.forName(new StringBuilder().append((Object)clName).append((Object)"$").toString());
            Field module = companionCls.getField("MODULE$");
            Object companionObj = module.get(null);
            none$ = new Some(companionObj);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("/Users/leo/work/git/airframe/surface/jvm/src/main/scala/wvlet/surface/reflect/ReflectTypeUtil.scala", "ReflectTypeUtil.scala", 49, 14), (Object)throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public synchronized <A extends AccessibleObject, B> B access(A f, Function0<B> body) {
        boolean accessible = f.isAccessible();
        try {
            if (!accessible) {
                f.setAccessible(true);
            }
            return (B)body.apply();
        }
        finally {
            if (!accessible) {
                f.setAccessible(false);
            }
        }
    }

    public Object readField(Object obj, Field f) {
        return this.access((AccessibleObject)f, (Function0)new Serializable(obj, f){
            public static final long serialVersionUID = 0L;
            private final Object obj$1;
            private final Field f$1;

            public final Object apply() {
                return this.f$1.get(this.obj$1);
            }
            {
                this.obj$1 = obj$1;
                this.f$1 = f$1;
            }
        });
    }

    public boolean canBuildFromBuffer(Surface s) {
        return this.isArray(s) || this.isSeq(s.rawType()) || this.isMap(s.rawType()) || this.isSet(s.rawType());
    }

    public boolean canBuildFromString(Surface s) {
        return this.isPrimitive(s) || this.hasStringUnapplyConstructor(s);
    }

    public boolean isPrimitive(Surface s) {
        return s.isPrimitive();
    }

    public boolean isArray(Surface s) {
        return s instanceof ArraySurface;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean isArray(Class<T> cl) {
        if (cl.isArray()) return true;
        String string = cl.getSimpleName();
        String string2 = "Array";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public <T> boolean isJavaColleciton(Class<T> cl) {
        return Collection.class.isAssignableFrom(cl);
    }

    public boolean hasStringUnapplyConstructor(Surface s) {
        return this.hasStringUnapplyConstructor(s.rawType());
    }

    public boolean hasStringUnapplyConstructor(Class<?> cl) {
        return BoxesRunTime.unboxToBoolean((Object)this.companionObject(cl).map((Function1)new Serializable(cl){
            public static final long serialVersionUID = 0L;
            public final Class cl$1;

            public final boolean apply(Object co) {
                return Predef$.MODULE$.refArrayOps((Object[])ReflectTypeUtil$.MODULE$.cls(co).getDeclaredMethods()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.hasStringUnapplyConstructor.2 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Method p) {
                        String string = p.getName();
                        String string2 = "unapply";
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        if (!this.acceptString$1(p)) return false;
                        if (!this.returnOptionOfT$1(p)) return false;
                        return true;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    private final boolean acceptString$1(Method p$1) {
                        Class<?>[] t = p$1.getParameterTypes();
                        if (t.length != 1) return false;
                        Class<?> clazz = t[0];
                        Class<String> clazz2 = String.class;
                        if (clazz != null) {
                            if (!clazz.equals(clazz2)) return false;
                            return true;
                        }
                        if (clazz2 == null) return true;
                        return false;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    private final boolean returnOptionOfT$1(Method p$1) {
                        Type rt = p$1.getGenericReturnType();
                        Class<?>[] t = ReflectTypeUtil$.MODULE$.getTypeParameters(rt);
                        if (!ReflectTypeUtil$.MODULE$.isOption(p$1.getReturnType())) return false;
                        if (t.length != 1) return false;
                        Class<?> clazz = t[0];
                        Class clazz2 = this.$outer.cl$1;
                        if (clazz != null) {
                            if (!clazz.equals(clazz2)) return false;
                            return true;
                        }
                        if (clazz2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).isDefined();
            }
            {
                this.cl$1 = cl$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    public boolean isOption(Surface s) {
        return s.isOption();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean isOption(Class<T> cl) {
        String name2;
        String string = name2 = cl.getSimpleName();
        String string2 = "Option";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = name2;
        String string4 = "Some";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = name2;
        String string6 = "None$";
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public <T> boolean isBuffer(Class<T> cl) {
        return Buffer.class.isAssignableFrom(cl);
    }

    public <T> boolean isSeq(Class<T> cl) {
        return Seq.class.isAssignableFrom(cl);
    }

    public <T> boolean isParSeq(Class<T> cl) {
        return ParSeq.class.isAssignableFrom(cl);
    }

    public <T> boolean isIndexedSeq(Class<T> cl) {
        return IndexedSeq.class.isAssignableFrom(cl) || this.isArray(cl);
    }

    public <T> boolean isMap(Class<T> cl) {
        return Map.class.isAssignableFrom(cl);
    }

    public <T> boolean isJavaMap(Class<T> cl) {
        return java.util.Map.class.isAssignableFrom(cl);
    }

    public <T> boolean isSet(Class<T> cl) {
        return Set.class.isAssignableFrom(cl);
    }

    public <T> boolean isTuple(Class<T> cl) {
        return Product.class.isAssignableFrom(cl) && cl.getName().startsWith("Tuple");
    }

    public <T> boolean isList(Class<T> cl) {
        return List.class.isAssignableFrom(cl);
    }

    public <T> boolean isEither(Class<T> cl) {
        return Either.class.isAssignableFrom(cl);
    }

    public Class<?>[] getTypeParameters(Field f) {
        return this.getTypeParameters(f.getGenericType());
    }

    public Class<?>[] getTypeParameters(Type gt) {
        Type type = gt;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class[] classArray = (Class[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])parameterizedType.getActualTypeArguments()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Class<?> apply(Type x$1) {
                    return ReflectTypeUtil$.MODULE$.resolveClassType(x$1);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Class.class)))).toArray(ClassTag$.MODULE$.apply(Class.class));
            return classArray;
        }
        throw new MatchError((Object)type);
    }

    public Class<?> resolveClassType(Type t) {
        Class clazz;
        Type type = t;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getRawType();
        } else {
            Class clazz2;
            clazz = type instanceof Class ? (clazz2 = (Class)type) : Object.class;
        }
        return clazz;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReflectTypeUtil$() {
        MODULE$ = this;
        LoggingMethods.class.$init$((LoggingMethods)this);
        LazyLogger.class.$init$((LazyLogger)this);
    }
}

