/*
 * Decompiled with CFR 0.152.
 */
package wvlet.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import wvlet.config.YamlReader$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;
import wvlet.obj.ObjectBuilder;
import wvlet.obj.ObjectBuilder$;

public final class YamlReader$
implements LogSupport {
    public static final YamlReader$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new YamlReader$();
    }

    private Logger logger$lzycompute() {
        YamlReader$ yamlReader$ = this;
        synchronized (yamlReader$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogger.class.logger((LazyLogger)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public <Resource extends AutoCloseable, U> U wvlet$config$YamlReader$$withResource(Resource resource, Function1<Resource, U> body) {
        try {
            return (U)body.apply(resource);
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String readAsString(String resourcePath) {
        void var2_2;
        Predef$.MODULE$.require(resourcePath != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"resourcePath is null"})).s((Seq)Nil$.MODULE$);
            }
        });
        File file = this.findPath(new File(resourcePath));
        if (file.exists()) {
            return (String)this.readFully(new FileInputStream(file), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(byte[] data) {
                    return new String(data, StandardCharsets.UTF_8);
                }
            });
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    private <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.wvlet$config$YamlReader$$withResource((AutoCloseable)new ByteArrayOutputStream(), (Function1)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final byte[] apply(ByteArrayOutputStream b) {
                byte[] buf = new byte[8192];
                YamlReader$.MODULE$.wvlet$config$YamlReader$$withResource(this.in$1, new Serializable(this, buf, b){
                    public static final long serialVersionUID = 0L;
                    private final byte[] buf$1;
                    private final ByteArrayOutputStream b$1;

                    public final void apply(InputStream src) {
                        int readBytes = 0;
                        while ((readBytes = src.read(this.buf$1)) != -1) {
                            this.b$1.write(this.buf$1, 0, readBytes);
                        }
                    }
                    {
                        this.buf$1 = buf$1;
                        this.b$1 = b$1;
                    }
                });
                return b.toByteArray();
            }
            {
                this.in$1 = in$1;
            }
        });
        return (U)f.apply((Object)byteArray);
    }

    private File findPath(String path) {
        return this.findPath(new File(path));
    }

    /*
     * WARNING - void declaration
     */
    private File findPath(File path) {
        block4: {
            File file;
            block3: {
                void var2_2;
                block2: {
                    if (!path.exists()) break block2;
                    file = path;
                    break block3;
                }
                File defaultPath = new File(new File(System.getProperty("prog.home", "")), path.getPath());
                if (!defaultPath.exists()) break block4;
                file = var2_2;
            }
            return file;
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    public <A> A load(String resourcePath, String env, ClassTag<A> m) {
        Map<String, A> map = this.loadMapOf(resourcePath, m);
        if (JavaConversions$.MODULE$.mapAsJavaMap(map).containsKey(env)) {
            return (A)map.apply((Object)env);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Env ", " is not found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{env, resourcePath})));
    }

    public <A> Map<String, A> loadMapOf(String resourcePath, ClassTag<A> m) {
        Map<Object, Object> yaml = this.loadYaml(resourcePath);
        Builder map = ListMap$.MODULE$.newBuilder();
        yaml.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(m, map){
            public static final long serialVersionUID = 0L;
            private final ClassTag m$1;
            private final Builder map$1;

            public final Builder<Tuple2<String, A>, ListMap<String, A>> apply(Tuple2<Object, Object> x$1) {
                Tuple2<Object, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    Builder builder = this.map$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toString()), YamlReader$.MODULE$.bind((java.util.Map)v, this.m$1)));
                    return builder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.m$1 = m$1;
                this.map$1 = map$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return (Map)map.result();
    }

    public Map<Object, Object> loadYaml(String resourcePath) {
        return JavaConversions$.MODULE$.mapAsScalaMap((java.util.Map)new Yaml().load(this.readAsString(resourcePath))).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Map<Object, Object>> loadYamlList(String resourcePath) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)new Yaml().load(this.readAsString(resourcePath))).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(java.util.Map<Object, Object> x$2) {
                return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$2).asScala()).toMap(Predef$.MODULE$.$conforms());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public <A> A bind(java.util.Map<Object, Object> prop, ClassTag<A> m) {
        ObjectBuilder builder = ObjectBuilder$.MODULE$.apply(m.runtimeClass());
        if (prop != null) {
            JavaConversions$.MODULE$.mapAsScalaMap(prop).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(builder){
                public static final long serialVersionUID = 0L;
                public final ObjectBuilder builder$1;

                public final void apply(Tuple2<Object, Object> x$3) {
                    Tuple2<Object, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Object object = v;
                        if (object instanceof ArrayList) {
                            ArrayList arrayList = (ArrayList)object;
                            JavaConversions$.MODULE$.asScalaBuffer((List)arrayList).foreach((Function1)new Serializable(this, k){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.bind.2 $outer;
                                private final Object k$1;

                                public final void apply(Object a) {
                                    this.$outer.builder$1.set(this.k$1.toString(), a);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.k$1 = k$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.builder$1.set(k.toString(), v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.builder$1 = builder$1;
                }
            });
        }
        return (A)builder.build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private YamlReader$() {
        MODULE$ = this;
        LoggingMethods.class.$init$((LoggingMethods)this);
        LazyLogger.class.$init$((LazyLogger)this);
    }
}

