/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.regex.Pattern;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$ERROR$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogLevel$TRACE$;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogRecord;

public final class LogFormatter$ {
    public static LogFormatter$ MODULE$;
    private final ZoneId systemZone;
    private final DateTimeFormatter noSpaceTimestampFormat;
    private final DateTimeFormatter humanReadableTimestampFormatter;
    private final Pattern testFrameworkFilter;
    private final Function1<String, Object> DEFAULT_STACKTRACE_FILTER;
    private Function1<String, Object> stackTraceFilter;

    static {
        new LogFormatter$();
    }

    public ZoneId systemZone() {
        return this.systemZone;
    }

    public DateTimeFormatter noSpaceTimestampFormat() {
        return this.noSpaceTimestampFormat;
    }

    public DateTimeFormatter humanReadableTimestampFormatter() {
        return this.humanReadableTimestampFormatter;
    }

    public String formatTimestamp(long timeMillis, DateTimeFormatter dateTimeformatter) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), this.systemZone());
        return dateTimeformatter.format(timestamp);
    }

    public DateTimeFormatter formatTimestamp$default$2() {
        return this.humanReadableTimestampFormatter();
    }

    public String currentThreadName() {
        return Thread.currentThread().getName();
    }

    private Pattern testFrameworkFilter() {
        return this.testFrameworkFilter;
    }

    public Function1<String, Object> DEFAULT_STACKTRACE_FILTER() {
        return this.DEFAULT_STACKTRACE_FILTER;
    }

    private Function1<String, Object> stackTraceFilter() {
        return this.stackTraceFilter;
    }

    private void stackTraceFilter_$eq(Function1<String, Object> x$1) {
        this.stackTraceFilter = x$1;
    }

    public void setStackTraceFilter(Function1<String, Object> filter) {
        this.stackTraceFilter_$eq(filter);
    }

    public String formatStacktrace(Throwable e) {
        StringWriter trace = new StringWriter();
        e.printStackTrace(new PrintWriter(trace));
        String stackTrace = trace.toString();
        Iterator filtered = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace.split("\n"))).filter(this.stackTraceFilter()))).sliding(2).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends String[], B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = Array$.MODULE$.unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String a = (String)((SeqLike)option.get()).apply(0);
                    String b = (String)((SeqLike)option.get()).apply(1);
                    String string = a;
                    String string2 = b;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        object = a;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(String[] x1) {
                String[] stringArray = x1;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty()) return false;
                if (option.get() == null) return false;
                if (((SeqLike)option.get()).lengthCompare(2) != 0) return false;
                String a = (String)((SeqLike)option.get()).apply(0);
                String b = (String)((SeqLike)option.get()).apply(1);
                String string = a;
                String string2 = b;
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
        });
        return filtered.mkString("\n");
    }

    public String withColor(String prefix, String s) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, s, "\u001b[0m"}));
    }

    public String highlightLog(LogLevel level, String message) {
        LogLevel logLevel = level;
        String string = LogLevel$ERROR$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$WARN$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$INFO$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$DEBUG$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$TRACE$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
        String color = string;
        return this.withColor(color, message);
    }

    public String appendStackTrace(String m, LogRecord r) {
        String string;
        Option<Throwable> option = r.cause();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable ex = (Throwable)some.value();
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m, this.highlightLog(r.level(), this.formatStacktrace(ex))}));
        } else if (None$.MODULE$.equals(option)) {
            string = m;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$DEFAULT_STACKTRACE_FILTER$1(LogFormatter$ $this, String line) {
        return !$this.testFrameworkFilter().matcher(line).matches();
    }

    private LogFormatter$() {
        MODULE$ = this;
        this.systemZone = ZoneId.systemDefault().normalized();
        this.noSpaceTimestampFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
        this.humanReadableTimestampFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
        this.testFrameworkFilter = Pattern.compile("\\s+at (sbt\\.|org\\.scalatest\\.).*");
        this.DEFAULT_STACKTRACE_FILTER = (Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)LogFormatter$.$anonfun$DEFAULT_STACKTRACE_FILTER$1(this, line));
        this.stackTraceFilter = this.DEFAULT_STACKTRACE_FILTER();
    }
}

