/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import wvlet.log.Guard;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005u!B\u0001\u0003\u0011\u00039\u0011a\u0004'pO2+g/\u001a7TG\u0006tg.\u001a:\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003xm2,Go\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001f1{w\rT3wK2\u001c6-\u00198oKJ\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u0017\u0013\t\u0007I\u0011B\f\u0002\r1|wmZ3s+\u0005A\u0002C\u0001\u0005\u001a\u0013\tQ\"A\u0001\u0004M_\u001e<WM\u001d\u0005\u00079%\u0001\u000b\u0011\u0002\r\u0002\u000f1|wmZ3sA!1a$\u0003C\u0001\u0005}\tAa]2b]R\u0019\u0001E\n\u001f\u0011\u00075\t3%\u0003\u0002#\u001d\t1q\n\u001d;j_:\u0004\"!\u0004\u0013\n\u0005\u0015r!\u0001\u0002'p]\u001eDQaJ\u000fA\u0002!\na\u0003\\8h\u0019\u00164X\r\u001c$jY\u0016\u001c\u0015M\u001c3jI\u0006$Xm\u001d\t\u0004SE\"dB\u0001\u00160\u001d\tYc&D\u0001-\u0015\tic!\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011\u0001GD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114GA\u0002TKFT!\u0001\r\b\u0011\u0005UJdB\u0001\u001c8!\tYc\"\u0003\u00029\u001d\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAd\u0002C\u0003>;\u0001\u0007\u0001%A\tmCN$8kY1o]\u0016$W*\u001b7mSN4\u0001bP\u0005\u0011\u0002G\u0005\"\u0001\u0011\u0002\r'\u000e\fgN\\3s'R\fG/Z\n\u0003}1ICA\u0010\"K!\u001a11)\u0003E\u0001\u0005\u0011\u0013qAU+O\u001d&suiE\u0002C\u0019\u0015\u0003\"A\u0012 \u000e\u0003%AQa\u0005\"\u0005\u0002!#\u0012!\u0013\t\u0003\r\n3aaS\u0005\t\u0002\ta%aB*U\u001fB\u0003V\tR\n\u0004\u00152)\u0005\"B\nK\t\u0003qE#A(\u0011\u0005\u0019SeAB)\n\u0011\u0003\u0011!K\u0001\u0005T)>\u0003\u0006+\u0013(H'\r\u0001F\"\u0012\u0005\u0006'A#\t\u0001\u0016\u000b\u0002+B\u0011a\tU\u0004\u0007/&A\tAA%\u0002\u000fI+fJT%O\u000f\u001e1\u0011,\u0003E\u0001\u0005U\u000b\u0001b\u0015+P!BKejR\u0004\u00077&A\tAA(\u0002\u000fM#v\n\u0015)F\t\u001a)!B\u0001\u0001\u0003;N\u0019A\f\u00040\u0011\u0005!y\u0016B\u00011\u0003\u0005\u00159U/\u0019:e\u0011\u0015\u0019B\f\"\u0001c)\u0005\u0019\u0007C\u0001\u0005]\u0011\u001d)GL1A\u0005\n\u0019\faaY8oM&<W#A4\u0011\u0007!\f8/D\u0001j\u0015\tQ7.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003Y6\f!bY8oGV\u0014(/\u001a8u\u0015\tqw.\u0001\u0003vi&d'\"\u00019\u0002\t)\fg/Y\u0005\u0003e&\u0014q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0003\u0011QL!!\u001e\u0002\u0003+1{w\rT3wK2\u001c6-\u00198oKJ\u001cuN\u001c4jO\"1q\u000f\u0018Q\u0001\n\u001d\fqaY8oM&<\u0007\u0005C\u0004z9\n\u0007I\u0011\u0002>\u0002\u001b\r|gNZ5h\u0007\"\fgnZ3e+\u0005Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@l\u0003\u0015awnY6t\u0013\r\t\t! \u0002\n\u0007>tG-\u001b;j_:Dq!!\u0002]A\u0003%10\u0001\bd_:4\u0017nZ\"iC:<W\r\u001a\u0011\t\u000f\u0005%A\f\"\u0001\u0002\f\u0005Iq-\u001a;D_:4\u0017nZ\u000b\u0002g\"9\u0011q\u0002/\u0005\u0002\u0005E\u0011!C:fi\u000e{gNZ5h)\u0011\t\u0019\"!\u0007\u0011\u00075\t)\"C\u0002\u0002\u00189\u0011A!\u00168ji\"1Q-!\u0004A\u0002MD\u0011\"!\b]\u0005\u0004%I!a\b\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005\u0005\u0002\u0003\u00025r\u0003G\u00012!!\n?\u001d\r\t9\u0003\u0001\b\u0005\u0003S\tiCD\u0002,\u0003WI\u0011!B\u0005\u0003\u0007\u0011A\u0001\"!\r]A\u0003%\u0011\u0011E\u0001\u0007gR\fG/\u001a\u0011\t\u000f\u0005UB\f\"\u0001\u00028\u0005)1\u000f^1siV\u0011\u00111\u0003\u0005\b\u0003waF\u0011AA\u001c\u0003\u0011\u0019Ho\u001c9\t\u0013\u0005}B\f1A\u0005\n\u0005\u0005\u0013a\u00057bgR\u001c6\r[3ek2,G-T5mY&\u001cX#\u0001\u0011\t\u0013\u0005\u0015C\f1A\u0005\n\u0005\u001d\u0013a\u00067bgR\u001c6\r[3ek2,G-T5mY&\u001cx\fJ3r)\u0011\t\u0019\"!\u0013\t\u0013\u0005-\u00131IA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!9\u0011q\n/!B\u0013\u0001\u0013\u0001\u00067bgR\u001c6\r[3ek2,G-T5mY&\u001c\b\u0005\u0003\u0005>9\u0002\u0007I\u0011BA!\u0011%\t)\u0006\u0018a\u0001\n\u0013\t9&A\u000bmCN$8kY1o]\u0016$W*\u001b7mSN|F%Z9\u0015\t\u0005M\u0011\u0011\f\u0005\n\u0003\u0017\n\u0019&!AA\u0002\u0001Bq!!\u0018]A\u0003&\u0001%\u0001\nmCN$8kY1o]\u0016$W*\u001b7mSN\u0004\u0003bBA19\u0012%\u0011qG\u0001\u0004eVtgABA39\u0012\t9GA\u000bM_\u001edUM^3m'\u000e\fgN\\3s)\"\u0014X-\u00193\u0014\t\u0005\r\u0014\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN8\u0002\t1\fgnZ\u0005\u0005\u0003g\niG\u0001\u0004UQJ,\u0017\r\u001a\u0005\b'\u0005\rD\u0011AA<)\t\tI\b\u0005\u0003\u0002|\u0005\rT\"\u0001/\t\u0011\u0005\u0005\u00141\rC!\u0003\u007f\"\"!a\u0005")
public class LogLevelScanner
implements Guard {
    private final AtomicReference<LogLevelScannerConfig> config;
    private final Condition configChanged;
    private final AtomicReference<ScannerState> state;
    private Option<Object> lastScheduledMillis;
    private Option<Object> lastScannedMillis;
    private final ReentrantLock wvlet$log$Guard$$lock;

    @Override
    public Condition newCondition() {
        return Guard.newCondition$(this);
    }

    @Override
    public <U> U guard(Function0<U> body) {
        return (U)Guard.guard$(this, body);
    }

    @Override
    public ReentrantLock wvlet$log$Guard$$lock() {
        return this.wvlet$log$Guard$$lock;
    }

    @Override
    public final void wvlet$log$Guard$_setter_$wvlet$log$Guard$$lock_$eq(ReentrantLock x$1) {
        this.wvlet$log$Guard$$lock = x$1;
    }

    private AtomicReference<LogLevelScannerConfig> config() {
        return this.config;
    }

    private Condition configChanged() {
        return this.configChanged;
    }

    public LogLevelScannerConfig getConfig() {
        return this.config().get();
    }

    public void setConfig(LogLevelScannerConfig config) {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogLevelScannerConfig prev = this.config().get();
            Seq<String> seq = prev.logLevelFileCandidates();
            Seq<String> seq2 = config.logLevelFileCandidates();
            if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                this.lastScannedMillis_$eq((Option<Object>)None$.MODULE$);
            }
            this.config().set(config);
            this.configChanged().signalAll();
        });
    }

    private AtomicReference<ScannerState> state() {
        return this.state;
    }

    public void start() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$RUNNING$.MODULE$);
                if (!this.state().compareAndSet(LogLevelScanner$STOPPED$.MODULE$, LogLevelScanner$RUNNING$.MODULE$)) break block0;
                new LogLevelScannerThread().start();
            }
        });
    }

    public void stop() {
        this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.state().set(LogLevelScanner$STOPPING$.MODULE$));
    }

    private Option<Object> lastScheduledMillis() {
        return this.lastScheduledMillis;
    }

    private void lastScheduledMillis_$eq(Option<Object> x$1) {
        this.lastScheduledMillis = x$1;
    }

    private Option<Object> lastScannedMillis() {
        return this.lastScannedMillis;
    }

    private void lastScannedMillis_$eq(Option<Object> x$1) {
        this.lastScannedMillis = x$1;
    }

    public void wvlet$log$LogLevelScanner$$run() {
        while (!this.state().compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$STOPPED$.MODULE$)) {
            long currentTimeMillis = System.currentTimeMillis();
            long scanIntervalMillis = this.getConfig().scanInterval().toMillis();
            if (this.lastScheduledMillis().isEmpty() || currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get()) > scanIntervalMillis) {
                Option<Object> updatedLastScannedMillis = LogLevelScanner$.MODULE$.scan(this.getConfig().logLevelFileCandidates(), this.lastScannedMillis());
                this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lastScannedMillis_$eq(updatedLastScannedMillis));
                this.lastScheduledMillis_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentTimeMillis)));
            }
            long sleepTime = scanIntervalMillis - package$.MODULE$.max(0L, package$.MODULE$.min(scanIntervalMillis, currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis().get())));
            this.guard((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (!this.configChanged().await(sleepTime, TimeUnit.MILLISECONDS)) {
                    // empty if block
                }
            });
        }
    }

    public LogLevelScanner() {
        Guard.$init$(this);
        this.config = new AtomicReference<LogLevelScannerConfig>(new LogLevelScannerConfig((Seq<String>)((Seq)Seq$.MODULE$.empty()), LogLevelScannerConfig$.MODULE$.apply$default$2()));
        this.configChanged = this.newCondition();
        this.state = new AtomicReference<LogLevelScanner$STOPPED$>(LogLevelScanner$STOPPED$.MODULE$);
        this.lastScheduledMillis = None$.MODULE$;
        this.lastScannedMillis = None$.MODULE$;
    }

    public class LogLevelScannerThread
    extends Thread {
        @Override
        public void run() {
            this.wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer().wvlet$log$LogLevelScanner$$run();
        }

        public /* synthetic */ LogLevelScanner wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer() {
            return LogLevelScanner.this;
        }

        public LogLevelScannerThread() {
            if (LogLevelScanner.this == null) {
                throw null;
            }
            this.setName("WvletLogLevelScanner");
            this.setDaemon(true);
        }
    }

    public static interface ScannerState {
    }
}

