/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.LogFormatter;
import wvlet.log.LogFormatter$SourceCodeLogFormatter$;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevelScanner;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.Logger;
import wvlet.log.io.IOUtil$;

public final class Logger$
implements scala.Serializable {
    public static Logger$ MODULE$;
    private Map<String, Logger> loggerCache;
    private Logger rootLogger;
    private LogLevelScanner logLevelScanner;
    private final Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    private volatile byte bitmap$0;

    static {
        new Logger$();
    }

    private Map<String, Logger> loggerCache$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.loggerCache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.loggerCache;
    }

    private Map<String, Logger> loggerCache() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.loggerCache$lzycompute() : this.loggerCache;
    }

    private Logger rootLogger$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$2 = "";
                Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsoleLogHandler[]{new ConsoleLogHandler(LogFormatter$SourceCodeLogFormatter$.MODULE$)}));
                Option<LogLevel> x$4 = this.initLogger$default$2();
                boolean x$5 = this.initLogger$default$4();
                this.rootLogger = this.initLogger(x$2, x$4, (Seq<Handler>)x$3, x$5);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rootLogger;
    }

    public Logger rootLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rootLogger$lzycompute() : this.rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1 & Serializable & scala.Serializable)l -> {
            logger.setLogLevel(l);
            return BoxedUnit.UNIT;
        });
        handlers.foreach((Function1 & Serializable & scala.Serializable)h -> {
            logger.addHandler(h);
            return BoxedUnit.UNIT;
        });
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        return (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, (Function0 & Serializable & scala.Serializable)() -> new Logger(java.util.logging.Logger.getLogger(loggerName)));
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public void setDefaultFormatter(LogFormatter formatter) {
        this.rootLogger().resetHandler(new ConsoleLogHandler(formatter));
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void setLogLevels(File file) {
        Properties logLevels = new Properties();
        IOUtil$.MODULE$.withResource(new FileReader(file), (Function1 & Serializable & scala.Serializable)in -> {
            logLevels.load(in);
            return BoxedUnit.UNIT;
        });
        this.setLogLevels(logLevels);
    }

    public void setLogLevels(Properties logLevels) {
        ((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(logLevels).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$setLogLevels$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Logger$.$anonfun$setLogLevels$3(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return this.DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    }

    public void scanLogLevels() {
        this.scanLogLevels(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES());
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogLevelScanner$.MODULE$.scan(loglevelFileCandidates, (Option<Object>)None$.MODULE$);
    }

    public void scheduleLogLevelScan() {
        this.scheduleLogLevelScan(new LogLevelScannerConfig(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES)));
    }

    private LogLevelScanner logLevelScanner$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logLevelScanner = new LogLevelScanner();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logLevelScanner;
    }

    public LogLevelScanner logLevelScanner() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logLevelScanner$lzycompute() : this.logLevelScanner;
    }

    public void scheduleLogLevelScan(LogLevelScannerConfig config) {
        this.logLevelScanner().setConfig(config);
        this.logLevelScanner().start();
    }

    public void stopScheduledLogLevelScan() {
        this.logLevelScanner().stop();
    }

    /*
     * WARNING - void declaration
     */
    public String getSuccinctLoggerName(Class<?> cl) {
        void var2_3;
        Class<?>[] interfaces;
        String name = cl.getName().contains("$anon$") ? ((interfaces = cl.getInterfaces()) != null && interfaces.length > 0 ? interfaces[0].getName() : cl.getName()) : cl.getName();
        return name.endsWith("$") ? name.substring(0, name.length() - 1) : var2_3;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$setLogLevels$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setLogLevels$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String loggerName = (String)tuple2._1();
        String level = (String)tuple2._2();
        Option<LogLevel> option = LogLevel$.MODULE$.unapply(level);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogLevel lv = (LogLevel)some.value();
            MODULE$.apply(loggerName).setLogLevel(lv);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown loglevel ", " is specified for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level, loggerName})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Logger$() {
        MODULE$ = this;
        this.DEFAULT_LOGLEVEL_FILE_CANDIDATES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log-test.properties", "log.properties"}));
    }
}

