/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wvlet.log.io.Resource;

public final class Resource$ {
    public static Resource$ MODULE$;

    static {
        new Resource$();
    }

    public <U> U open(Class<?> referenceClass, String resourceFileName, Function1<BufferedInputStream, U> body) {
        Object object;
        Option<URL> u = this.find(referenceClass, resourceFileName);
        if (u.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Resource %s (in %s) not found")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceFileName, referenceClass.getSimpleName()})));
        }
        try (BufferedInputStream s = new BufferedInputStream(((URL)u.get()).openStream());){
            object = body.apply((Object)s);
        }
        return (U)object;
    }

    private String packagePath(Class<?> referenceClass) {
        return this.packagePath(referenceClass.getPackage());
    }

    private String packagePath(Package basePackage) {
        return this.packagePath(basePackage.getName());
    }

    private String packagePath(String packageName) {
        String packageAsPath = packageName.replaceAll("\\.", "/");
        return packageAsPath.endsWith("/") ? packageAsPath : packageAsPath + "/";
    }

    private Stream<URLClassLoader> classLoaders(ClassLoader cl) {
        return this.stream$1(cl);
    }

    private Stream<ClassLoader> classLoaders() {
        return this.classLoaders(Thread.currentThread().getContextClassLoader());
    }

    private String resolveResourcePath(String packageName, String resourceFileName) {
        String path = this.packagePath(packageName);
        return this.prependSlash(path + resourceFileName);
    }

    private String prependSlash(String name) {
        return name.startsWith("/") ? name : "/" + name;
    }

    public Option<URL> find(Class<?> referenceClass, String resourceFileName) {
        return this.find(this.packagePath(referenceClass), resourceFileName);
    }

    public Option<URL> find(String absoluteResourcePath) {
        return this.find("", absoluteResourcePath.startsWith("/") ? absoluteResourcePath.substring(1) : absoluteResourcePath);
    }

    public Option<URL> find(String packageName, String resourceFileName) {
        String resourcePath = this.resolveResourcePath(packageName, resourceFileName);
        Option r = ((TraversableOnce)this.classLoaders().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getResource(resourcePath), Stream$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends URL, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null ? (A1 = A12) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(URL x1) {
                URL uRL = x1;
                boolean bl = uRL != null;
                return bl;
            }
        });
        return r.orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.getClass().getResource(resourcePath)));
    }

    private String extractLogicalName(String packagePath, String resourcePath) {
        String p = !packagePath.endsWith("/") ? packagePath + "/" : packagePath;
        int pos = resourcePath.indexOf(p);
        if (pos < 0) {
            return null;
        }
        String logicalName = resourcePath.substring(pos + p.length());
        return logicalName;
    }

    private Seq<Resource.VirtualFile> collectFileResources(String resourceURLString, String packagePath, Function1<String, Object> resourceFilter) {
        Builder b;
        block1: {
            String logicalName = this.extractLogicalName(packagePath, resourceURLString);
            if (logicalName == null) {
                throw new IllegalArgumentException("packagePath=" + packagePath + ", resourceURL=" + resourceURLString);
            }
            b = Seq$.MODULE$.newBuilder();
            File file = new File(new URL(resourceURLString).toURI());
            Object object = BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)file.getPath())) ? b.$plus$eq((Object)new Resource.SystemFile(file, logicalName)) : BoxedUnit.UNIT;
            if (!file.isDirectory()) break block1;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)childFile -> {
                String childResourceURL = resourceURLString + (resourceURLString.endsWith("/") ? "" : "/") + childFile.getName();
                return (Builder)b.$plus$plus$eq(this.collectFileResources(childResourceURL, packagePath, resourceFilter));
            });
        }
        return (Seq)b.result();
    }

    private Seq<Resource.VirtualFile> listResources(URL resourceURL, String packageName, Function1<String, Object> resourceFilter) {
        Growable growable;
        String protocol;
        String pkgPath = this.packagePath(packageName);
        Builder fileList = Seq$.MODULE$.newBuilder();
        if (resourceURL == null) {
            return (Seq)Seq$.MODULE$.empty();
        }
        String string = protocol = resourceURL.getProtocol();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String resourceURLString = resourceURL.toString();
            growable = fileList.$plus$plus$eq(this.collectFileResources(resourceURLString, pkgPath, resourceFilter));
        } else {
            String string3 = protocol;
            String string4 = "jar";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String path = resourceURL.getPath();
                int pos = path.indexOf("!");
                if (pos < 0) {
                    throw new IllegalArgumentException("invalid resource URL: " + resourceURL);
                }
                String jarPath = path.substring(0, pos).replaceAll("%20", " ");
                String filePath = path.substring(0, pos).replaceAll("%20", " ").replace("file:", "");
                String jarURLString = "jar:" + jarPath;
                JarFile jf = new JarFile(filePath);
                Enumeration<JarEntry> entryEnum = jf.entries();
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String physicalURL = jarURLString + "!/" + jarEntry.getName();
                    URL jarFileURL = new URL(physicalURL);
                    String logicalName = this.extractLogicalName(pkgPath, jarEntry.getName());
                    Object object = logicalName != null && BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)logicalName)) ? fileList.$plus$eq((Object)new Resource.FileInJar(jarFileURL, logicalName, jarEntry.isDirectory())) : BoxedUnit.UNIT;
                }
            } else {
                throw new UnsupportedOperationException("resources other than file or jar are not supported: " + resourceURL);
            }
            growable = BoxedUnit.UNIT;
        }
        return (Seq)fileList.result();
    }

    public Seq<Resource.VirtualFile> listResources(String packageName) {
        return this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Resource$.$anonfun$listResources$1(f)), this.listResources$default$3());
    }

    public Seq<Resource.VirtualFile> listResources(String packageName, Function1<String, Object> resourceFilter, ClassLoader classLoader) {
        Builder b = Seq$.MODULE$.newBuilder();
        this.findResourceURLs(classLoader, packageName).foreach((Function1 & Serializable & scala.Serializable)u -> (Builder)b.$plus$plus$eq(this.listResources((URL)u, packageName, resourceFilter)));
        return (Seq)b.result();
    }

    public ClassLoader listResources$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Seq<URL> findResourceURLs(ClassLoader cl, String name) {
        String path = this.packagePath(name);
        Builder b = Seq$.MODULE$.newBuilder();
        this.classLoaders(cl).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Resource$.$anonfun$findResourceURLs$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Resource$.$anonfun$findResourceURLs$2(path, b, c);
            return BoxedUnit.UNIT;
        });
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(String packageName, Class<A> toSearch, ClassLoader classLoader) {
        Seq<Resource.VirtualFile> classFileList = this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.endsWith(".class")), classLoader);
        Builder b = Seq$.MODULE$.newBuilder();
        classFileList.foreach((Function1 & Serializable & scala.Serializable)vf -> {
            Resource$.$anonfun$findClasses$2(packageName, toSearch, classLoader, b, vf);
            return BoxedUnit.UNIT;
        });
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(Package searchPath, Class<A> toSearch, ClassLoader classLoader) {
        return this.findClasses(searchPath.getName(), toSearch, classLoader);
    }

    public <A> ClassLoader findClasses$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    private final Stream stream$1(ClassLoader c) {
        Stream stream;
        while (true) {
            ClassLoader classLoader;
            if ((classLoader = c) == null) {
                stream = package$.MODULE$.Stream().empty();
                break;
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader uRLClassLoader;
                URLClassLoader uRLClassLoader2 = uRLClassLoader = (URLClassLoader)classLoader;
                stream = Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.stream$1(c.getParent())).$hash$colon$colon((Object)uRLClassLoader2);
                break;
            }
            c = c.getParent();
        }
        return stream;
    }

    public static final /* synthetic */ boolean $anonfun$listResources$1(String f) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findResourceURLs$1(URLClassLoader check$ifrefutable$1) {
        URLClassLoader uRLClassLoader = check$ifrefutable$1;
        boolean bl = uRLClassLoader != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$findResourceURLs$2(String path$1, Builder b$3, URLClassLoader c) {
        Enumeration<URL> e = c.findResources(path$1);
        while (e.hasMoreElements()) {
            b$3.$plus$eq((Object)e.nextElement());
        }
    }

    private static final Option componentName$1(String path) {
        int dot = path.lastIndexOf(".");
        return dot <= 0 ? None$.MODULE$ : new Some((Object)path.substring(0, dot).replaceAll("/", "."));
    }

    private static final Option findClass$1(String name, ClassLoader classLoader$1) {
        Some some;
        try {
            some = new Some(Class.forName(name, false, classLoader$1));
        }
        catch (ClassNotFoundException e) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$findClasses$3(String packageName$2, Class toSearch$1, ClassLoader classLoader$1, Builder b$4, String cn) {
        String className = packageName$2 + "." + cn;
        Resource$.findClass$1(className, classLoader$1).foreach((Function1 & Serializable & scala.Serializable)cl -> !Modifier.isAbstract(cl.getModifiers()) && toSearch$1.isAssignableFrom((Class<?>)cl) ? b$4.$plus$eq(cl) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$findClasses$2(String packageName$2, Class toSearch$1, ClassLoader classLoader$1, Builder b$4, Resource.VirtualFile vf) {
        Resource$.componentName$1(vf.logicalPath()).foreach((Function1 & Serializable & scala.Serializable)cn -> {
            Resource$.$anonfun$findClasses$3(packageName$2, toSearch$1, classLoader$1, b$4, cn);
            return BoxedUnit.UNIT;
        });
    }

    private Resource$() {
        MODULE$ = this;
    }
}

