/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi;

import java.util.HashMap;
import java.util.Map;

public class ResponseStatus {
    static Map<Integer, ResponseStatus> instanceMap = new HashMap<Integer, ResponseStatus>();
    public static final ResponseStatus SUCCESS = new ResponseStatus(200, "Success");
    public static final ResponseStatus CREATED = new ResponseStatus(201, "Created");
    public static final ResponseStatus NO_CONTENT = new ResponseStatus(204, "No Content");
    public static final ResponseStatus MULTI_STATUS = new ResponseStatus(207, "Multi-Status");
    public static final ResponseStatus MULTIPLE_CHOICES = new ResponseStatus(300, "Multiple Choices");
    public static final ResponseStatus MOVED_TEMPORARILY = new ResponseStatus(302, "Moved Temporarily");
    public static final ResponseStatus BAD_REQUEST = new ResponseStatus(400, "Bad Request");
    public static final ResponseStatus UNAUTHORIZED = new ResponseStatus(401, "Unauthorized");
    public static final ResponseStatus FORBIDDEN = new ResponseStatus(403, "Forbidden");
    public static final ResponseStatus NOT_FOUND = new ResponseStatus(404, "Resource not found");
    public static final ResponseStatus METHOD_NOT_ALLOWED = new ResponseStatus(405, "Method Not Allowed");
    public static final ResponseStatus NOT_ACCEPTABLE = new ResponseStatus(406, "Not Acceptable");
    public static final ResponseStatus PRECONDITION_FAILED = new ResponseStatus(412, "Precondition Failed");
    public static final ResponseStatus EXPECTATION_FAILED = new ResponseStatus(417, "Expectation Failed");
    public static final ResponseStatus INTERNAL_SERVER_ERROR = new ResponseStatus(500, "Internal Server Error");
    public static final ResponseStatus NOT_IMPLEMENTED = new ResponseStatus(501, "Not Implemented");
    private int code;
    private String reasonPrase;

    private ResponseStatus(int code) {
        this.code = code;
        instanceMap.put(new Integer(code), this);
    }

    private ResponseStatus(int code, String reasonPrase) {
        this.code = code;
        this.reasonPrase = reasonPrase;
        instanceMap.put(new Integer(code), this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResponseStatus)) {
            return false;
        }
        return this.code == ((ResponseStatus)object).code;
    }

    public int hashCode() {
        return this.code;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Response-Status code ");
        buffer.append(this.code);
        buffer.append(", message ");
        buffer.append(this.reasonPrase);
        return buffer.toString();
    }

    public int getCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.reasonPrase;
    }

    public static synchronized ResponseStatus getInstanceByCode(int code) {
        if (instanceMap.containsKey(new Integer(code))) {
            return instanceMap.get(new Integer(code));
        }
        return new ResponseStatus(code);
    }
}

