/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class URIScheme {
    static Map<String, URIScheme> stringInstanceMap = Collections.synchronizedMap(new HashMap());
    public static final URIScheme HTTP = new URIScheme("http");
    public static final URIScheme HTTPS = new URIScheme("https");
    public static final URIScheme HTTPSY = new URIScheme("httpsy");
    private String lowerCaseString;

    private URIScheme(String lowerCaseString) {
        stringInstanceMap.put(lowerCaseString, this);
        this.lowerCaseString = lowerCaseString;
    }

    public static URIScheme getURIScheme(String schemeString) {
        return URIScheme.getURISchemeFromLowercaseString(schemeString.toLowerCase());
    }

    public static URIScheme getURISchemeFromLowercaseString(String lowerCaseString) {
        URIScheme existing = stringInstanceMap.get(lowerCaseString);
        if (existing == null) {
            return new URIScheme(lowerCaseString);
        }
        return existing;
    }

    public String getStringRepresentation() {
        return this.lowerCaseString;
    }
}

