/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.activator;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.Handler;
import org.wymiwyg.wrhapi.ServerBinding;
import org.wymiwyg.wrhapi.WebServer;
import org.wymiwyg.wrhapi.WebServerFactory;
import org.wymiwyg.wrhapi.filter.Filter;
import org.wymiwyg.wrhapi.filter.impl.FilterRunner;
import org.wymiwyg.wrhapi.util.pathmappings.PathMappingHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator {
    private final Logger log = LoggerFactory.getLogger(Activator.class);
    private WebServer webServer;
    private ConfigurationAdmin configurationAdmin;
    private Map<String, Handler> nameServiceMap;
    private Set<ServiceReference> handlerRefs = new HashSet<ServiceReference>();
    private List<Filter> filters = new ArrayList<Filter>();
    private WebServerFactory webServerFactory;
    private int port = 8282;

    public Activator() {
        this.log.info("constructing activator");
    }

    public void setPort(int port) throws Exception {
        this.port = port;
    }

    protected void bindHandler(ServiceReference handlerRef) {
        this.handlerRefs.add(handlerRef);
    }

    private void resolveHandler(ServiceReference handlerRef, ComponentContext context) {
        this.log.info("binding: " + handlerRef);
        String name = (String)handlerRef.getProperty("service.pid");
        Handler handler = (Handler)context.locateService("handler", handlerRef);
        if (handler == null) {
            this.log.error("Could not get service for " + name);
        } else {
            this.nameServiceMap.put(name, handler);
        }
    }

    protected void unbindHandler(ServiceReference handlerRef) {
        this.handlerRefs.add(handlerRef);
    }

    protected void bindFilter(Filter filter) {
        this.filters.add(filter);
    }

    protected void unbindFilter(Filter filter) {
        this.filters.remove(filter);
    }

    protected void activate(ComponentContext context) throws Exception {
        this.log.info("Activating WRHAPI (" + this.configurationAdmin + ")");
        this.nameServiceMap = new HashMap<String, Handler>();
        for (ServiceReference ref : this.handlerRefs) {
            this.resolveHandler(ref, context);
        }
        try {
            String portStr = (String)context.getProperties().get("port");
            this.port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Map<String, ParameterizedPath> mappingMap = this.getMappings((String[])context.getProperties().get("mappings"));
        PathMappingHandler mappingHandler = new PathMappingHandler();
        for (Map.Entry<String, Handler> entry : this.nameServiceMap.entrySet()) {
            String pid = entry.getKey();
            ParameterizedPath parameterizedPath = mappingMap.get(pid);
            mappingHandler.addHandler(entry.getValue(), parameterizedPath.getPath(), pid, parameterizedPath.removePrefix(), parameterizedPath.isOverlay());
        }
        Handler handler = mappingHandler;
        if (this.filters.size() > 0) {
            this.log.info("Activating WRHAPI with " + this.filters.size() + " filters");
            handler = new FilterRunner(this.filters.toArray(new Filter[this.filters.size()]), handler);
        }
        try {
            this.log.info("Starting webserver at port " + this.port);
            this.webServer = this.webServerFactory.startNewWebServer(handler, new ServerBinding(){

                public InetAddress getInetAddress() {
                    return null;
                }

                public int getPort() {
                    return Activator.this.port;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.webServer.stop();
        this.webServer = null;
    }

    private Map<String, ParameterizedPath> getMappings(String[] mappings) throws IOException {
        HashMap<String, ParameterizedPath> result = new HashMap<String, ParameterizedPath>();
        HashSet<String> knownServiceNames = new HashSet<String>(this.nameServiceMap.keySet());
        for (String mapping : mappings) {
            if ("[placeholder]".equals(mapping)) continue;
            int firstEqualsPos = mapping.indexOf(61);
            if (firstEqualsPos == -1) {
                this.log.warn("invalid mapping " + mapping);
                continue;
            }
            String key = mapping.substring(0, firstEqualsPos);
            String value = mapping.substring(firstEqualsPos + 1);
            result.put(key, new ParameterizedPath(value));
            knownServiceNames.remove(key);
        }
        if (knownServiceNames.size() > 0) {
            Configuration config = this.configurationAdmin.getConfiguration(Activator.class.getName());
            Hashtable<String, String[]> properties = config.getProperties();
            if (properties == null) {
                properties = new Hashtable<String, String[]>();
            }
            String[] newValues = new String[mappings.length + knownServiceNames.size()];
            for (int i = 0; i < mappings.length; ++i) {
                newValues[i] = mappings[i];
            }
            for (String string : knownServiceNames) {
                newValues[i++] = string + "=/";
                result.put(string, new ParameterizedPath("/"));
            }
            ((Dictionary)properties).put("mappings", newValues);
            config.update(properties);
        }
        return result;
    }

    protected void bindWebServerFactory(WebServerFactory webServerFactory) {
        this.webServerFactory = webServerFactory;
    }

    protected void unbindWebServerFactory(WebServerFactory webServerFactory) {
        if (this.webServerFactory == webServerFactory) {
            this.webServerFactory = null;
        }
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }

    private static class ParameterizedPath {
        String path;
        boolean removePrefix = true;
        boolean overlay = false;

        ParameterizedPath(String string) {
            String[] parts = string.split(";");
            this.path = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String currentPart = parts[i];
                String[] keyValue = currentPart.split("=");
                if (keyValue[0].equals("removePrefix")) {
                    this.removePrefix = this.parseBoolean(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals("overlay")) {
                    this.overlay = this.parseBoolean(keyValue[1]);
                    continue;
                }
                throw new RuntimeException("unrecognised path parameter: " + keyValue[0]);
            }
        }

        String getPath() {
            return this.path;
        }

        boolean isOverlay() {
            return this.overlay;
        }

        boolean removePrefix() {
            return this.removePrefix;
        }

        private boolean parseBoolean(String string) {
            if (string.equals("true")) {
                return true;
            }
            if (string.equals("false")) {
                return false;
            }
            throw new RuntimeException("boolean paramter value must be \"true\" or \"false\" (case sensitive)");
        }
    }
}

