/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;
import org.wymiwyg.wrhapi.Request;
import org.wymiwyg.wrhapi.URIScheme;
import org.wymiwyg.wrhapi.util.AcceptHeaderEntry;
import org.wymiwyg.wrhapi.util.AcceptHeaderIterator;
import org.wymiwyg.wrhapi.util.AcceptLanguagesIterator;
import org.wymiwyg.wrhapi.util.Cookie;
import org.wymiwyg.wrhapi.util.InvalidCookieException;
import org.wymiwyg.wrhapi.util.RequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedRequest
extends RequestWrapper {
    private String host;
    private int port = -1;

    public EnhancedRequest(Request base) {
        super(base);
    }

    public URL getFullRequestURL() throws HandlerException {
        String requestURIString = this.getRequestURI().toString();
        if (requestURIString.equals("//")) {
            requestURIString = "/";
        }
        try {
            return new URL(this.getRootURL(), requestURIString);
        }
        catch (MalformedURLException e) {
            throw new HandlerException(e);
        }
    }

    public URL getRequestURLWithoutParams() throws HandlerException {
        String requestURIString = this.getRequestURI().getPath();
        if (requestURIString.equals("//")) {
            requestURIString = "/";
        }
        try {
            return new URL(this.getRootURL(), requestURIString);
        }
        catch (MalformedURLException e) {
            throw new HandlerException(e);
        }
    }

    public URL getRootURL() throws HandlerException {
        URIScheme scheme = this.getScheme();
        int port = this.getRequestPort();
        StringBuffer url = new StringBuffer();
        url.append(scheme.getStringRepresentation());
        url.append("://");
        url.append(this.getHost());
        if (port > 0 && (scheme == URIScheme.HTTP && port != 80 || scheme == URIScheme.HTTPS && port != 443)) {
            url.append(':');
            url.append(port);
        }
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new HandlerException(e);
        }
    }

    private int getRequestPort() throws HandlerException {
        if (this.port == -1) {
            try {
                String hostHeader = this.getHeaderValues(HeaderName.HOST)[0];
                int colonPos = hostHeader.indexOf(58);
                this.port = colonPos != -1 ? Integer.parseInt(hostHeader.substring(colonPos + 1)) : this.getDefaultPortForScheme(this.getScheme());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.port = this.getPort();
            }
        }
        return this.port;
    }

    private int getDefaultPortForScheme(URIScheme scheme) {
        if (scheme == URIScheme.HTTP) {
            return 80;
        }
        if (scheme == URIScheme.HTTPS) {
            return 443;
        }
        if (scheme == URIScheme.HTTPSY) {
            return 80;
        }
        throw new RuntimeException("unsupported scheme");
    }

    public Cookie[] getCookies() throws HandlerException {
        String[] headers = this.getHeaderValues(HeaderName.COOKIE);
        ArrayList<Cookie> resultCollection = new ArrayList<Cookie>();
        for (int i = 0; i < headers.length; ++i) {
            StringTokenizer tokens = new StringTokenizer(headers[i], ";,");
            while (tokens.hasMoreElements()) {
                try {
                    resultCollection.add(new Cookie(tokens.nextToken()));
                }
                catch (InvalidCookieException e) {
                    throw new HandlerException(e);
                }
            }
        }
        return resultCollection.toArray(new Cookie[resultCollection.size()]);
    }

    private String getHost() throws HandlerException {
        if (this.host == null) {
            try {
                this.host = this.getHeaderValues(HeaderName.HOST)[0];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new HandlerException("No host header");
            }
            int colonPos = this.host.indexOf(58);
            if (colonPos != -1) {
                this.host = this.host.substring(0, colonPos);
            }
        }
        return this.host;
    }

    public Iterator<AcceptHeaderEntry> getAccept() throws HandlerException {
        String[] acceptStrings = this.getHeaderValues(HeaderName.ACCEPT);
        return new AcceptHeaderIterator(acceptStrings);
    }

    public AcceptLanguagesIterator getAcceptLanguages() throws HandlerException {
        String[] acceptStrings = this.getHeaderValues(HeaderName.ACCEPT_LANGUAGE);
        return new AcceptLanguagesIterator(acceptStrings);
    }
}

