/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.MimeType;
import org.wymiwyg.wrhapi.util.InvalidPatternException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaRange
implements Comparable<MediaRange> {
    private String type;
    private String subtype;
    Map<String, String> parameters = new HashMap<String, String>();

    public MediaRange(String pattern) throws InvalidPatternException {
        try {
            StringTokenizer subtypeParamTokens;
            if (pattern.indexOf(47) > -1) {
                StringTokenizer tokens = new StringTokenizer(pattern, "/");
                this.type = tokens.nextToken();
                String subtypeAnParams = tokens.nextToken();
                subtypeParamTokens = new StringTokenizer(subtypeAnParams, ";");
                this.subtype = subtypeParamTokens.nextToken();
            } else {
                if (pattern.charAt(0) != '*') {
                    throw new InvalidPatternException("Invalid pattern " + pattern + ": ");
                }
                this.type = "*";
                this.subtype = "*";
                subtypeParamTokens = new StringTokenizer(pattern, ";");
                subtypeParamTokens.nextToken();
            }
            while (subtypeParamTokens.hasMoreTokens()) {
                String parameterToken = subtypeParamTokens.nextToken();
                StringTokenizer nameValueSplitter = new StringTokenizer(parameterToken, "=");
                String name = nameValueSplitter.nextToken().trim();
                String value = nameValueSplitter.nextToken().trim();
                this.parameters.put(name, value);
            }
        }
        catch (Exception e) {
            throw new InvalidPatternException("Invalid pattern " + pattern + ": ");
        }
    }

    public boolean match(MimeType mimeType) {
        if (this.match(this.type, mimeType.getPrimaryType()) && this.match(this.subtype, mimeType.getSubType())) {
            for (String currentName : this.parameters.keySet()) {
                String typeParameterValue = mimeType.getParameter(currentName);
                if (typeParameterValue == null) {
                    return false;
                }
                if (typeParameterValue.equals(this.parameters.get(currentName))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean match(String pattern, String string) {
        boolean result = pattern.equals("*") || pattern.equals(string);
        return result;
    }

    public String toString() {
        StringWriter resultWriter = new StringWriter();
        resultWriter.write(this.type);
        resultWriter.write(47);
        resultWriter.write(this.subtype);
        for (String currentName : this.parameters.keySet()) {
            String currentValue = this.parameters.get(currentName);
            resultWriter.write("; ");
            resultWriter.write(currentName);
            resultWriter.write(currentValue);
        }
        return resultWriter.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof MediaRange) {
            return ((MediaRange)arg0).type.equals(this.type) && ((MediaRange)arg0).subtype.equals(this.subtype);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.subtype.hashCode();
    }

    public int getAsterixCount() {
        if (this.subtype.equals("*")) {
            return 2;
        }
        if (this.type.equals("*")) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(MediaRange other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.getAsterixCount() > other.getAsterixCount()) {
            return 1;
        }
        if (this.getAsterixCount() < other.getAsterixCount()) {
            return -1;
        }
        return this.toString().compareTo(other.toString());
    }
}

