/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util.parameterparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.wymiwyg.wrhapi.MessageBody;
import org.wymiwyg.wrhapi.util.parameterparser.AbstractParameterCollection;
import org.wymiwyg.wrhapi.util.parameterparser.KeyValuePair;
import org.wymiwyg.wrhapi.util.parameterparser.ParameterValue;
import org.wymiwyg.wrhapi.util.parameterparser.StringParameterValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLEncodedParameterCollection
extends AbstractParameterCollection {
    private String encodedCollection;

    public URLEncodedParameterCollection(MessageBody messageBody) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            messageBody.writeTo(Channels.newChannel(byteOut));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.encodedCollection = new String(byteOut.toByteArray());
    }

    public URLEncodedParameterCollection(String encodedCollection) {
        this.encodedCollection = encodedCollection;
    }

    @Override
    public Iterator<KeyValuePair<ParameterValue>> iterator() {
        if (this.rawCollection == null) {
            this.rawCollection = new ArrayList();
            if (this.encodedCollection != null) {
                StringTokenizer tokens = new StringTokenizer(this.encodedCollection, "&");
                while (tokens.hasMoreTokens()) {
                    String currentToken = tokens.nextToken();
                    int indexOfEquals = currentToken.indexOf(61);
                    String key = currentToken.substring(0, indexOfEquals);
                    try {
                        StringParameterValue value = new StringParameterValue(URLDecoder.decode(currentToken.substring(indexOfEquals + 1), "utf-8"));
                        this.rawCollection.add(new KeyValuePair<StringParameterValue>(URLDecoder.decode(key, "utf-8"), value));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.rawCollection.iterator();
    }
}

