/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util.pathmappings;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.wrhapi.Handler;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.HeaderName;
import org.wymiwyg.wrhapi.MessageBody;
import org.wymiwyg.wrhapi.Request;
import org.wymiwyg.wrhapi.Response;
import org.wymiwyg.wrhapi.ResponseStatus;

class OverlayHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(OverlayHandler.class);
    private Handler overlay;
    private Handler base;

    public OverlayHandler(Handler overlay, Handler base) {
        this.overlay = overlay;
        this.base = base;
    }

    public void handle(Request request, final Response response) throws HandlerException {
        final ResponseStatus[] responseStatusArray = new ResponseStatus[1];
        logger.info("Attempt to handle with overlay " + this.overlay.getClass());
        this.overlay.handle(request, new Response(){

            public void setBody(MessageBody body) throws HandlerException {
                if (!ResponseStatus.NOT_FOUND.equals(responseStatusArray[0])) {
                    response.setBody(body);
                }
            }

            public void setHeader(HeaderName headerName, Object value) throws HandlerException {
                if (!ResponseStatus.NOT_FOUND.equals(responseStatusArray[0])) {
                    response.setHeader(headerName, value);
                }
            }

            public void addHeader(HeaderName headerName, Object value) throws HandlerException {
                if (!ResponseStatus.NOT_FOUND.equals(responseStatusArray[0])) {
                    response.addHeader(headerName, value);
                }
            }

            public void setResponseStatus(ResponseStatus status) throws HandlerException {
                if (ResponseStatus.NOT_FOUND.equals(responseStatusArray[0])) {
                    response.setResponseStatus(status);
                } else {
                    responseStatusArray[0] = status;
                }
            }
        });
        if (responseStatusArray[0].equals(ResponseStatus.NOT_FOUND)) {
            logger.info("overlay returned 404, handling with " + this.base.getClass());
            this.base.handle(request, response);
        } else {
            logger.info("overlay returned " + responseStatusArray[0]);
        }
    }
}

