/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util.pathmappings;

import java.util.HashMap;
import java.util.Map;
import org.wymiwyg.wrhapi.Handler;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.Request;
import org.wymiwyg.wrhapi.Response;
import org.wymiwyg.wrhapi.ResponseStatus;
import org.wymiwyg.wrhapi.util.pathmappings.MultiSelectHandler;
import org.wymiwyg.wrhapi.util.pathmappings.OverlayHandler;
import org.wymiwyg.wrhapi.util.pathmappings.PrefixRemovingRequest;

public class PathMappingHandler
implements Handler {
    private Map<String, Handler> pathHandlerMap = new HashMap<String, Handler>();

    public void addHandler(Handler handler, String path, String uid, boolean removePrefixInRequests, boolean overlay) {
        if (handler == null) {
            throw new IllegalArgumentException("handler may not be null");
        }
        String uniquePath = path.charAt(path.length() - 1) == '/' ? path + uid + '/' : path + '/' + uid;
        if (this.pathHandlerMap.containsKey(uniquePath)) {
            throw new RuntimeException("The path " + uniquePath + " must be unique ");
        }
        RegisteredHandler registeredHandler = new RegisteredHandler(handler, path, uniquePath, removePrefixInRequests);
        this.pathHandlerMap.put(uniquePath, registeredHandler);
        if (this.pathHandlerMap.containsKey(path)) {
            Handler newHandler;
            Handler existing = this.pathHandlerMap.get(path);
            if (overlay) {
                newHandler = new OverlayHandler(registeredHandler, existing);
            } else {
                MultiSelectHandler multiSelectHandler;
                if (existing instanceof MultiSelectHandler) {
                    multiSelectHandler = (MultiSelectHandler)existing;
                } else {
                    multiSelectHandler = new MultiSelectHandler();
                    String existingUid = ((RegisteredHandler)existing).uniquePath;
                    multiSelectHandler.addOption(existingUid);
                }
                multiSelectHandler.addOption(uniquePath);
                newHandler = multiSelectHandler;
            }
            this.pathHandlerMap.put(path, newHandler);
        } else {
            this.pathHandlerMap.put(path, registeredHandler);
        }
    }

    public void handle(Request request, Response response) throws HandlerException {
        String requestPath = request.getRequestURI().getPath();
        Handler handler = this.getHandler(requestPath);
        if (handler != null) {
            handler.handle(request, response);
        } else {
            response.setResponseStatus(ResponseStatus.NOT_FOUND);
        }
    }

    private Handler getHandler(String requestPath) {
        Handler result = this.pathHandlerMap.get(requestPath);
        if (result != null) {
            return result;
        }
        if (requestPath.length() <= 1) {
            return null;
        }
        String remainingPath = requestPath.substring(0, requestPath.lastIndexOf(47, requestPath.length() - 2) + 1);
        return this.getHandler(remainingPath);
    }

    private static class RegisteredHandler
    implements Handler {
        Handler handler;
        String path;
        String uniquePath;
        boolean removePrefixInRequests;

        public RegisteredHandler(Handler handler, String path, String uniquePath, boolean removePrefixInRequests) {
            this.handler = handler;
            this.path = path;
            this.uniquePath = uniquePath;
            this.removePrefixInRequests = removePrefixInRequests;
        }

        public void handle(Request request, Response response) throws HandlerException {
            if (this.removePrefixInRequests) {
                request = new PrefixRemovingRequest(request, this.path, this.uniquePath);
            }
            this.handler.handle(request, response);
        }
    }
}

