/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util;

import org.wymiwyg.wrhapi.util.InvalidPatternException;
import org.wymiwyg.wrhapi.util.MediaRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptHeaderEntry
implements Comparable<AcceptHeaderEntry> {
    MediaRange range;
    float q;

    public AcceptHeaderEntry(MediaRange range, float q) {
        this.range = range;
        this.q = q;
    }

    public AcceptHeaderEntry(String string) throws InvalidPatternException {
        if ("*".equals(string)) {
            string = "*/*";
        }
        this.range = new MediaRange(string);
        String qString = this.range.parameters.remove("q");
        if (qString == null) {
            this.q = 1.0f;
        } else {
            try {
                this.q = Float.parseFloat(qString);
            }
            catch (NumberFormatException ex) {
                throw new InvalidPatternException("could not parse " + qString + " as number in" + string);
            }
        }
    }

    public float getQ() {
        return this.q;
    }

    public MediaRange getRange() {
        return this.range;
    }

    @Override
    public int compareTo(AcceptHeaderEntry other) {
        if (this.q > other.q) {
            return -1;
        }
        if (this.q < other.q) {
            return 1;
        }
        return this.range.compareTo(other.range);
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(AcceptHeaderEntry.class)) {
            return this.q == ((AcceptHeaderEntry)other).q && this.range == ((AcceptHeaderEntry)other).range;
        }
        return false;
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.range.toString());
        buffer.append("; q=");
        buffer.append(this.q);
        return buffer.toString();
    }
}

