/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util;

import java.util.Date;
import org.wymiwyg.wrhapi.util.HTTPDateFormat;
import org.wymiwyg.wrhapi.util.InvalidCookieException;

public class Cookie {
    private String name;
    private String value;
    private String path;
    private String maxAge;

    public Cookie(String cookie) throws InvalidCookieException {
        int equalPos;
        int colonPos = cookie.indexOf(";");
        if (colonPos != -1) {
            cookie = cookie.substring(0, cookie.indexOf(";"));
        }
        if ((equalPos = cookie.indexOf("=")) == -1) {
            throw new InvalidCookieException("No = sign found");
        }
        this.name = cookie.substring(0, equalPos).trim();
        this.value = cookie.substring(cookie.indexOf("=") + 1, cookie.length());
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append('=');
        buffer.append(this.value);
        buffer.append("; path=");
        if (this.path == null) {
            buffer.append("/");
        } else {
            buffer.append(this.path);
        }
        if (this.maxAge != null) {
            buffer.append("; Max-Age=");
            buffer.append(this.maxAge);
            if (!this.maxAge.equals("-1")) {
                buffer.append("; expires=");
                buffer.append(new HTTPDateFormat().format(new Date(System.currentTimeMillis() + (long)Integer.parseInt(this.maxAge) * 1000L)));
            }
        }
        return buffer.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = Integer.toString(maxAge);
    }
}

