/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi;

import java.io.StringWriter;

public class HeaderName {
    public static final Object CONTENT_DISPOSITION = new HeaderName("Content-Disposition");
    public static final HeaderName TRANSFER_ENCODING = new HeaderName("Transfer-Encoding");
    public static HeaderName ACCEPT = new HeaderName("Accept");
    public static HeaderName HOST = new HeaderName("Host");
    public static HeaderName CONTENT_TYPE = new HeaderName("Content-Type");
    public static HeaderName ACCEPT_LANGUAGE = new HeaderName("Accept-Language");
    public static HeaderName CONTENT_LENGTH = new HeaderName("Content-Length");
    public static HeaderName CONTENT_ENCODING = new HeaderName("Content-Encoding");
    public static HeaderName CONTENT_LANGUAGE = new HeaderName("Content-Language");
    public static HeaderName COOKIE = new HeaderName("Cookie");
    public static HeaderName SET_COOKIE = new HeaderName("Set-Cookie");
    public static HeaderName LOCATION = new HeaderName("Location");
    public static HeaderName REFERER = new HeaderName("Referer");
    public static final HeaderName PRAGMA = new HeaderName("Pragma");
    public static final HeaderName EXPIRES = new HeaderName("Expires");
    public static final HeaderName AUTHORIZATION = new HeaderName("Authorization");
    public static final HeaderName CACHE_CONTROL = new HeaderName("Cache-Control");
    public static final HeaderName USER_AGENT = new HeaderName("User-Agent");
    public static final HeaderName WWW_AUTHENTICATE = new HeaderName("Www-Authenticate");
    public static final HeaderName DEPTH = new HeaderName("Depth");
    public static final HeaderName DAV = new HeaderName("Dav");
    public static final HeaderName ALLOW = new HeaderName("Allow");
    public static final HeaderName LAST_MODIFIED = new HeaderName("Last-Modified");
    public static final HeaderName SERVER = new HeaderName("Server");
    public static final HeaderName IF_MODIFIED_SINCE = new HeaderName("If-Modified-Since");
    public static final HeaderName IF_NONE_MATCH = new HeaderName("If-None-Match");
    private String normalizedCaseName;

    private HeaderName(String normalizedCaseName) {
        this.normalizedCaseName = normalizedCaseName;
    }

    public static HeaderName get(String name) {
        return new HeaderName(HeaderName.normalizeCase(name));
    }

    public String toString() {
        return this.normalizedCaseName;
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(HeaderName.class)) {
            return false;
        }
        return this.normalizedCaseName.equals(((HeaderName)object).normalizedCaseName);
    }

    public int hashCode() {
        return this.normalizedCaseName.hashCode();
    }

    private static String normalizeCase(String string) {
        StringWriter resultWriter = new StringWriter(string.length());
        boolean lastCharADash = false;
        for (int i = 0; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (i == 0 || lastCharADash) {
                resultWriter.write(Character.toUpperCase(currentChar));
            } else {
                resultWriter.write(Character.toLowerCase(currentChar));
            }
            lastCharADash = currentChar == '-';
        }
        return resultWriter.toString();
    }
}

