/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util;

import java.util.Locale;
import java.util.StringTokenizer;
import org.wymiwyg.wrhapi.util.LocaleRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptLanguageHeaderEntry
implements Comparable<AcceptLanguageHeaderEntry> {
    private LocaleRange localeRange;
    private float q;

    public AcceptLanguageHeaderEntry(String headerEntry) {
        StringTokenizer tokens = new StringTokenizer(headerEntry, ";");
        String firstToken = tokens.nextToken();
        this.localeRange = firstToken.equals("*") ? new LocaleRange() : new LocaleRange(this.parseLocale(firstToken));
        this.q = tokens.hasMoreTokens() ? this.readQ(tokens.nextToken()) : 1.0f;
    }

    private float readQ(String string) {
        int eqPos = string.indexOf(61);
        return Float.parseFloat(string.substring(eqPos + 1));
    }

    private Locale parseLocale(String language) {
        int underscorePos = language.indexOf(95);
        if (underscorePos > -1) {
            return new Locale(language.substring(0, underscorePos), language.substring(underscorePos + 1));
        }
        int dashPos = language.indexOf(45);
        if (dashPos > -1) {
            return new Locale(language.substring(0, dashPos), language.substring(dashPos + 1));
        }
        return new Locale(language);
    }

    public LocaleRange getLocaleRange() {
        return this.localeRange;
    }

    public float getQ() {
        return this.q;
    }

    @Override
    public int compareTo(AcceptLanguageHeaderEntry other) {
        if (this.q > other.q) {
            return -1;
        }
        if (this.q < other.q) {
            return 1;
        }
        return this.localeRange.toString().compareTo(other.localeRange.toString());
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(AcceptLanguageHeaderEntry.class)) {
            return this.q == ((AcceptLanguageHeaderEntry)other).q && this.localeRange == ((AcceptLanguageHeaderEntry)other).localeRange;
        }
        return false;
    }

    public int hashCode() {
        return this.localeRange.hashCode();
    }
}

