/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.wrhapi.util.pathmappings;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import org.wymiwyg.wrhapi.Handler;
import org.wymiwyg.wrhapi.HandlerException;
import org.wymiwyg.wrhapi.Request;
import org.wymiwyg.wrhapi.Response;
import org.wymiwyg.wrhapi.util.MessageBody2Write;

class MultiSelectHandler
implements Handler {
    private Set<String> options = new HashSet<String>();

    MultiSelectHandler() {
    }

    public void handle(Request request, Response response) throws HandlerException {
        final String absPath = request.getRequestURI().getAbsPath().substring(1);
        response.setBody(new MessageBody2Write(){

            public void writeTo(WritableByteChannel out) throws IOException {
                PrintWriter writer = new PrintWriter(Channels.newWriter(out, "utf-8"));
                writer.println("<html>");
                writer.println("<body>");
                writer.println("<h1>Multiple handlers configured for this path</h1>");
                for (String option : MultiSelectHandler.this.options) {
                    writer.println("<a href=" + option + absPath + ">" + option + absPath + "</a>");
                    writer.println("<br />");
                }
                writer.println("</body>");
                writer.println("</html>");
                writer.flush();
            }
        });
    }

    void addOption(String option) {
        this.options.add(option);
    }
}

