/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from /home/reto/workspace/wymiwyg-commons-jena/src/org/wymiwyg/commons/vocabulary/mod_attach.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class ATTACH {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://wymiwyg.org/ontologies/rss/attach#";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>The (preffered) media-type the refernced document should be included (i.e. 
     *  the first accept-header value the client should set when requesting the resource 
     *  with http)</p>
     */
    public static final Property type = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/attach#type" );
    
    /** <p>The width of an image.</p> */
    public static final Property width = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/attach#width" );
    
    /** <p>The height of an image.</p> */
    public static final Property height = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/attach#height" );
    
    /** <p>The attached document, the URI of the object of this property must be dereferenceable</p> */
    public static final Property document = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/attach#document" );
    
    /** <p>A sequence of attachments attached to an item</p> */
    public static final Property attachments = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/attach#attachments" );
    
    /** <p>Describes an attachment that should be (also) be displaied when showing the 
     *  article in summary-mode</p>
     */
    public static final Resource SummaryAttachment = m_model.createResource( "http://wymiwyg.org/ontologies/rss/attach#SummaryAttachment" );
    
    /** <p>Describes an attachment that should be displayed inline</p> */
    public static final Resource InlineAttachment = m_model.createResource( "http://wymiwyg.org/ontologies/rss/attach#InlineAttachment" );
    
    /** <p>Describes an attachment, attachment is a reference to another document with 
     *  infomation on how this is to be included to the document to which it is attached. 
     *  An attachment may have a rdfs:label, a dc:language and a rdfs:comment</p>
     */
    public static final Resource Attachment = m_model.createResource( "http://wymiwyg.org/ontologies/rss/attach#Attachment" );
    
}
