/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.ontology.*; 
/**
 * Vocabulary definitions from http://discobits.org/ontology.en.de.fr.it.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class DISCOBITS {
    /** <p>The ontology model that holds the vocabulary terms</p> */
    private static OntModel m_model = ModelFactory.createOntologyModel( OntModelSpec.OWL_MEM, null );
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://discobits.org/ontology#";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    public static final ObjectProperty bytes = m_model.createObjectProperty( "http://discobits.org/ontology#bytes" );
/** Constant <code>bytes</code> */
    
    public static final ObjectProperty entry = m_model.createObjectProperty( "http://discobits.org/ontology#entry" );
/** Constant <code>entry</code> */
    
    public static final ObjectProperty representedProperty = m_model.createObjectProperty( "http://discobits.org/ontology#representedProperty" );
/** Constant <code>representedProperty</code> */
    
    public static final ObjectProperty contained = m_model.createObjectProperty( "http://discobits.org/ontology#contained" );
/** Constant <code>contained</code> */
    
    public static final ObjectProperty mediaType = m_model.createObjectProperty( "http://discobits.org/ontology#mediaType" );
/** Constant <code>mediaType</code> */
    
    public static final OntProperty infoBit = m_model.createOntProperty( "http://discobits.org/ontology#infoBit" );
/** Constant <code>infoBit</code> */
    
    public static final OntClass Entry = m_model.createClass( "http://discobits.org/ontology#Entry" );
/** Constant <code>Entry</code> */
    
    public static final OntClass TitledContent = m_model.createClass( "http://discobits.org/ontology#TitledContent" );
/** Constant <code>TitledContent</code> */
    
    public static final OntClass OrderedContent = m_model.createClass( "http://discobits.org/ontology#OrderedContent" );
/** Constant <code>OrderedContent</code> */
    
    public static final OntClass ImageInfoDiscoBit = m_model.createClass( "http://discobits.org/ontology#ImageInfoDiscoBit" );
/** Constant <code>ImageInfoDiscoBit</code> */
    
    public static final OntClass InfoBit = m_model.createClass( "http://discobits.org/ontology#InfoBit" );
/** Constant <code>InfoBit</code> */
    
    public static final OntClass AlternativeSet = m_model.createClass( "http://discobits.org/ontology#AlternativeSet" );
/** Constant <code>AlternativeSet</code> */
    
    public static final OntClass XHTMLInfoDiscoBit = m_model.createClass( "http://discobits.org/ontology#XHTMLInfoDiscoBit" );
/** Constant <code>XHTMLInfoDiscoBit</code> */
    
    public static final OntClass InfoDiscoBit = m_model.createClass( "http://discobits.org/ontology#InfoDiscoBit" );
/** Constant <code>InfoDiscoBit</code> */
    
    public static final OntClass BinaryInfoDiscoBit = m_model.createClass( "http://discobits.org/ontology#BinaryInfoDiscoBit" );
/** Constant <code>BinaryInfoDiscoBit</code> */
    
    public static final OntClass DiscoBit = m_model.createClass( "http://discobits.org/ontology#DiscoBit" );
/** Constant <code>DiscoBit</code> */
    
}
