/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.ontology.*; 
/**
 * Vocabulary definitions from src/org/wymiwyg/commons/vocabulary/geof-extensions.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class GEOFEX {
    /** <p>The ontology model that holds the vocabulary terms</p> */
    private static OntModel m_model = ModelFactory.createOntologyModel( OntModelSpec.RDFS_MEM, null );
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://wymiwyg.org/ontologies/geof/extensions#";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>A document with the subject as the space thing primarily related to it. This 
     *  is different than the primaryTopicOf as the latter could be a political institution 
     *  rather than a space-thing.</p>
     */
    public static final OntProperty primarySpaceThingOf = m_model.createOntProperty( "http://wymiwyg.org/ontologies/geof/extensions#primarySpaceThingOf" );
    
    /** <p>A code for a SpatialThing, like a country or state-code</p> */
    public static final OntProperty code = m_model.createOntProperty( "http://wymiwyg.org/ontologies/geof/extensions#code" );
    
}
