/* CVS $Id: INFOATOM.java,v 1.1 2006/02/15 18:31:25 rebach Exp $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.ontology.*; 
/**
 * Vocabulary definitions from http://atomowl.org/ontologies/infoatom.de.fr.en.rdf
 *
 * @author Auto-generated by schemagen on 04 Feb 2006 16:31
 * @version $Id: $Id
 */
public class INFOATOM {
    /** <p>The ontology model that holds the vocabulary terms</p> */
    private static OntModel m_model = ModelFactory.createOntologyModel( OntModelSpec.OWL_MEM, null );
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://atomowl.org/ontologies/infoatom#";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    public static final ObjectProperty target = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#target" );
/** Constant <code>target</code> */
    
    public static final ObjectProperty component = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#component" );
/** Constant <code>component</code> */
    
    public static final ObjectProperty invalid = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#invalid" );
/** Constant <code>invalid</code> */
    
    public static final ObjectProperty author = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#author" );
/** Constant <code>author</code> */
    
    public static final ObjectProperty contributor = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#contributor" );
/** Constant <code>contributor</code> */
    
    public static final ObjectProperty componentRoleType = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#componentRoleType" );
/** Constant <code>componentRoleType</code> */
    
    public static final ObjectProperty componentRole = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#componentRole" );
/** Constant <code>componentRole</code> */
    
    public static final ObjectProperty representation = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#representation" );
/** Constant <code>representation</code> */
    
    public static final ObjectProperty inReplyTo = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#inReplyTo" );
/** Constant <code>inReplyTo</code> */
    
    /** <p>A Relation of which the subject is the source.</p> */
    public static final ObjectProperty link = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#link" );
    
    public static final ObjectProperty source = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#source" );
/** Constant <code>source</code> */
    
    public static final ObjectProperty bytes = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#bytes" );
/** Constant <code>bytes</code> */
    
    public static final ObjectProperty isTranslationOf = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#isTranslationOf" );
/** Constant <code>isTranslationOf</code> */
    
    public static final ObjectProperty encoding = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#encoding" );
/** Constant <code>encoding</code> */
    
    public static final ObjectProperty valid = m_model.createObjectProperty( "http://atomowl.org/ontologies/infoatom#valid" );
/** Constant <code>valid</code> */
    
    public static final DatatypeProperty mimeType = m_model.createDatatypeProperty( "http://atomowl.org/ontologies/infoatom#mimeType" );
/** Constant <code>mimeType</code> */
    
    public static final OntClass EncodingSet = m_model.createClass( "http://atomowl.org/ontologies/infoatom#EncodingSet" );
/** Constant <code>EncodingSet</code> */
    
    public static final OntClass InformationResource = m_model.createClass( "http://atomowl.org/ontologies/infoatom#InformationResource" );
/** Constant <code>InformationResource</code> */
    
    public static final OntClass Representation = m_model.createClass( "http://atomowl.org/ontologies/infoatom#Representation" );
/** Constant <code>Representation</code> */
    
    public static final OntClass Bytes = m_model.createClass( "http://atomowl.org/ontologies/infoatom#Bytes" );
/** Constant <code>Bytes</code> */
    
    public static final OntClass Encoding = m_model.createClass( "http://atomowl.org/ontologies/infoatom#Encoding" );
/** Constant <code>Encoding</code> */
    
    public static final OntClass LanguageSet = m_model.createClass( "http://atomowl.org/ontologies/infoatom#LanguageSet" );
/** Constant <code>LanguageSet</code> */
    
    public static final OntClass RevisionHistory = m_model.createClass( "http://atomowl.org/ontologies/infoatom#RevisionHistory" );
/** Constant <code>RevisionHistory</code> */
    
    public static final OntClass Relation = m_model.createClass( "http://atomowl.org/ontologies/infoatom#Relation" );
/** Constant <code>Relation</code> */
    
    public static final OntClass ComponentRole = m_model.createClass( "http://atomowl.org/ontologies/infoatom#ComponentRole" );
/** Constant <code>ComponentRole</code> */
    
}
