/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from /home/reto/workspace/wymiwyg-commons-jena/src/org/wymiwyg/commons/vocabulary/mod_link.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class LINK {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://wymiwyg.org/ontologies/rss/link#";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>The inverse property of target.</p> */
    public static final Property targetOf = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/link#targetOf" );
    
    /** <p>The target of a link.</p> */
    public static final Property target = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/link#target" );
    
    /** <p>A property of item or channel with an Sequence of Links as value.</p> */
    public static final Property links = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/link#links" );
    
    /** <p>The inverse property of link.</p> */
    public static final Property linkedBy = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/link#linkedBy" );
    
    /** <p>A property of item or channel with an instance of Link as value.</p> */
    public static final Property link = m_model.createProperty( "http://wymiwyg.org/ontologies/rss/link#link" );
    
    /** <p>This type of link provides a link to other language version of this channel. 
     *  Resource of this type usually have the dc:language and the link:target attribute.</p>
     */
    public static final Resource Language = m_model.createResource( "http://wymiwyg.org/ontologies/rss/link#Language" );
    
    /** <p>This links an item or channel to a channel which "contains" the item.</p> */
    public static final Resource Container = m_model.createResource( "http://wymiwyg.org/ontologies/rss/link#Container" );
    
    /** <p>This type of link provides a link to a subchannel of the current channel. 
     *  The target of the Link is subordinated to this channel.</p>
     */
    public static final Resource SubChannel = m_model.createResource( "http://wymiwyg.org/ontologies/rss/link#SubChannel" );
    
    /** <p>This type of link provides a link to the current RSS channel or item by topic. 
     *  This is generally an HTML or RSS file which contains RSS items on the same 
     *  topic as the current item/channel.</p>
     */
    public static final Resource Topic = m_model.createResource( "http://wymiwyg.org/ontologies/rss/link#Topic" );
    
    /** <p>Describes a link.</p> */
    public static final Resource Link = m_model.createResource( "http://wymiwyg.org/ontologies/rss/link#Link" );
    
}
