/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from /home/reto/workspace/wymiwyg-commons-jena/src/org/wymiwyg/commons/vocabulary/postaddress.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class POSTADDRESS {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://wymiwyg.org/ontologies/foaf/postaddress";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>Supplementary information where the delivery point is not uniquely identified 
     *  by other properties, e.g. letter-box number within a building.</p>
     */
    public static final Property extensionDesignation = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#extensionDesignation" );
    
    /** <p>Country, dependency or area of geopolitical interest, in which a delivery 
     *  point is located or via which the delivery point is accessed.</p>
     */
    public static final Property country = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#country" );
    
    /** <p>The type of the building/construction (e.g. "Block", "Houseboat", "Mobile 
     *  Home")</p>
     */
    public static final Property buildingType = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#buildingType" );
    
    /** <p>This has higher sorting relevance than thoroughfare type and qualifier</p> */
    public static final Property thoroughfareName = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#thoroughfareName" );
    
    /** <p>The type of the sector in which a building is located (e.g. conjunto)</p> */
    public static final Property sectorType = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#sectorType" );
    
    /** <p>This can both be recipient specif additional handling information (e.g. "summer 
     *  contest 2005") as well as suplementary delivery point data for the postal 
     *  operator (e.g. "Opposite number 23")</p>
     */
    public static final Property supplementaryDespatchData = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#supplementaryDespatchData" );
    
    /** <p></p> */
    public static final Property district = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#district" );
    
    /** <p></p> */
    public static final Property wing = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#wing" );
    
    /** <p>The name or number designating the specific instance of sector type</p> */
    public static final Property sectorIndicator = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#sectorIndicator" );
    
    /** <p>Directions to reach a geographical point.</p> */
    public static final Property location = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#location" );
    
    /** <p>E.g.: "upper", "new"</p> */
    public static final Property thoroughfareQualifier = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#thoroughfareQualifier" );
    
    /** <p>The secondary thoroughfare is a thoroughfare which accessed via (the primary) 
     *  thoroughfare</p>
     */
    public static final Property secondaryThoroughfareName = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#secondaryThoroughfareName" );
    
    /** <p></p> */
    public static final Property door = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#door" );
    
    /** <p></p> */
    public static final Property stairwel = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#stairwel" );
    
    /** <p></p> */
    public static final Property floor = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#floor" );
    
    /** <p>City of major town which is close to town</p> */
    public static final Property proximateTown = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#proximateTown" );
    
    /** <p>Links to information on the dispacth within the site or proximity of the recipient.</p> */
    public static final Property localDespatchingInformation = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#localDespatchingInformation" );
    
    /** <p>E.g.: "Street", "Avenue", "Calle"</p> */
    public static final Property secondaryThoroughfareType = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#secondaryThoroughfareType" );
    
    /** <p>E.g.: "Street", "Avenue", "Calle"</p> */
    public static final Property thoroughfareType = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#thoroughfareType" );
    
    /** <p>A mail delivery point speicfication specific to a postal operator</p> */
    public static final Property serviceDeliveryPointSpecification = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#serviceDeliveryPointSpecification" );
    
    public static final Property address = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#address" );
/** Constant <code>address</code> */
    
    public static final Property addressee = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#addressee" );
/** Constant <code>addressee</code> */
    
    /** <p>Postal address element designating the code used for sorting the mail. May 
     *  be operator specific (like "DX codes" in the U.K.), see #authority</p>
     */
    public static final Property postcode = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#postcode" );
    
    /** <p>Postal operator responsible for definining the element of #ServiceDeliveryPointSpecification 
     *  (lile postcode)</p>
     */
    public static final Property authority = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#authority" );
    
    /** <p>The region within a country</p> */
    public static final Property region = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#region" );
    
    /** <p>A phone number of a phone located at this address.</p> */
    public static final Property phone = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#phone" );
    
    /** <p>Links an address to information intended for routing and despatch of mail 
     *  by the mail recipient when this is not the addresse.</p>
     */
    public static final Property recipientDespatchingInformation = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#recipientDespatchingInformation" );
    
    /** <p>Name or number indicating the instance of the postal service delivery point 
     *  of the type indicated by #deliveryServiceType (e.g. the postbox number)</p>
     */
    public static final Property deliveryServiceIndicator = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#deliveryServiceIndicator" );
    
    /** <p>A fax number of a fax-machine located at this address.</p> */
    public static final Property fax = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#fax" );
    
    /** <p>e.g. "Poste Restante", "Postbox", the specific delivery point within the specified 
     *  category (like the postbox number) is identified by #deliveryServiceIndicator</p>
     */
    public static final Property deliveryServiceType = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#deliveryServiceType" );
    
    /** <p>Village, town or city</p> */
    public static final Property town = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#town" );
    
    /** <p>The name or number of the building/construction</p> */
    public static final Property building = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#building" );
    
    /** <p>Street number or plot, may be composite e.g. 6-8</p> */
    public static final Property streetNr = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#streetNr" );
    
    /** <p>Specified only if not same of addresse, this is commonly rendered after the 
     *  adresse prefixed with with "c/o" or "P.A."</p>
     */
    public static final Property mailee = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#mailee" );
    
    /** <p>Links an address to the specification of the point where the postal service 
     *  provider delivers the mail.</p>
     */
    public static final Property deliveryPoint = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#deliveryPoint" );
    
    /** <p>Associates a country-name to the subject.</p> */
    public static final Property countryName = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#countryName" );
    
    /** <p>Associates a two-letter country-code to the subject.</p> */
    public static final Property countryCode = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/postaddress#countryCode" );
    
    /** <p>A mail delivery point speicfication specific to a postal operator. Typical 
     *  properties are authority, postcode, deliveryServiceIndicator, deliveryServiceType 
     *  and deliveryServiceQualifier</p>
     */
    public static final Resource ServiceDeliveryPointSpecification = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#ServiceDeliveryPointSpecification" );
    
    /** <p>A Country, dependency or area of geopolitical interest, in which a delivery 
     *  point is located or via which the delivery point is accessed.</p>
     */
    public static final Resource Country = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#Country" );
    
    /** <p>Directions to reach a geographical point.</p> */
    public static final Resource Location = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#Location" );
    
    /** <p>Specification of the point where the postal service provider delivers the 
     *  mail. Typically has a property location with operator idependent information 
     *  and one or several serviceDeliveryPointSpecification-properties with information 
     *  specific to a postal operator (like postbox and postcode witch may not be 
     *  reachable or useful for another operator).</p>
     */
    public static final Resource DeliveryPoint = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#DeliveryPoint" );
    
    /** <p>Information intended for routing and despatch withing the site or building 
     *  of the recipient, this may be intended for the mail recipient as value of 
     *  recipientDespatchingInformation property of an address as well as for the 
     *  postal operator if a value of localDespatchInformation of a Location.</p>
     */
    public static final Resource LocalDespatchingInformation = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#LocalDespatchingInformation" );
    
    /** <p>An address to wich traditional postal letters can be sent. Common properties 
     *  are: addresse (a foaf:Agent), mailee (a foaf:Agent), recipientDespatchingInformation 
     *  and deliveryPoint</p>
     */
    public static final Resource Address = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/postaddress#Address" );
    
}
