/* CVS $Id: $ */
package org.wymiwyg.commons.vocabulary; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from /home/reto/workspace/wymiwyg-commons-jena/src/org/wymiwyg/commons/vocabulary/role.rdf
 *
 * @author Auto-generated by schemagen on 31 Mai 2007 01:33
 * @version $Id: $Id
 */
public class ROLE {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://wymiwyg.org/ontologies/foaf/role";
    
/**
 * <p>The namespace of the vocabulary as a string</p>
 *
 *  @see #NS
 * @return a {@link java.lang.String} object.
 */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>A role a group provieds, i.e. a role that participations in a group may act 
     *  in.</p>
     */
    public static final Property providesRole = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#providesRole" );
    
    /** <p>The role of the participipation in the group. This role must have the same 
     *  group as the subject.</p>
     */
    public static final Property actsInRole = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#actsInRole" );
    
    public static final Property hasParticipation = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#hasParticipation" );
/** Constant <code>hasParticipation</code> */
    
    /** <p>Indicates the group in which the participation described by the subject takes 
     *  place</p>
     */
    public static final Property group = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#group" );
    
    /** <p>Indicates the particpant in the participation described by the subject</p> */
    public static final Property participant = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#participant" );
    
    /** <p>Indicates a participation of the subject</p> */
    public static final Property participatesIn = m_model.createProperty( "http://wymiwyg.org/ontologies/foaf/role#participatesIn" );
    
    /** <p>Describes that and in which Role an Agent participates in a group. The group 
     *  is indicated by the group property (exactly 1), the participant by the participant 
     *  property (excatly 1), and an arbitrary number of roles with the exposesRole 
     *  property. Note that a participation may only have roles that belong to the 
     *  respective group, i.e. which have the same group property.</p>
     */
    public static final Resource Participation = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/role#Participation" );
    
    /** <p>Describes a Role (Function/Position) agents may have within a Group, a Role 
     *  is associated to exactly one group, so the role of the Chief-Idologist of 
     *  on group is never the same resource as the Chief-Ideologist of another group. 
     *  Multiple Particpations may howere have the same role. The rdfs:label should 
     *  be used to indicate the denotation of the role (like "Chief Ideologist"), 
     *  the foaf:name property may be used to indicate how a holder of this role may 
     *  be referred to, e.g. "Chief Ideologist of WYMIWYG.org".</p>
     */
    public static final Resource Role = m_model.createResource( "http://wymiwyg.org/ontologies/foaf/role#Role" );
    
}
