/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.jena.JenaUtil;
import org.wymiwyg.commons.vocabulary.CALENDAR;
import org.wymiwyg.commons.vocabulary.FOAF;
import org.wymiwyg.commons.vocabulary.GEOFEX;

public class InsertionIFPResolver {
    private static final Log log = LogFactory.getLog(InsertionIFPResolver.class);
    private static Set handledIFP = new HashSet();

    public static void process(Model mainModel, Model insertion) {
        Resource to;
        StmtIterator statements = insertion.listStatements();
        HashMap<Resource, Resource> replaceTable = new HashMap<Resource, Resource>();
        HashMap identitiesInExisting = new HashMap();
        while (statements.hasNext()) {
            Statement currentStmt = statements.nextStatement();
            Property currentPredicate = currentStmt.getPredicate();
            if (!handledIFP.contains(currentPredicate)) continue;
            ResIterator resInMain = mainModel.listSubjectsWithProperty((Property)currentPredicate.inModel(mainModel), currentStmt.getObject().inModel(mainModel));
            if (resInMain.hasNext()) {
                Resource sourceResource = currentStmt.getSubject();
                Resource targetResource = resInMain.nextResource();
                if (replaceTable.containsKey(sourceResource) && !replaceTable.get(sourceResource).equals(targetResource)) {
                    identitiesInExisting.put(replaceTable.get(sourceResource), targetResource);
                } else {
                    replaceTable.put(sourceResource, targetResource);
                }
                while (resInMain.hasNext()) {
                    log.warn((Object)("Model contains more than one resource with property " + currentStmt.getPredicate() + " to value " + currentStmt.getObject() + " will merge resources"));
                    identitiesInExisting.put(resInMain.nextResource(), targetResource);
                }
            }
            resInMain.close();
        }
        for (Resource from : replaceTable.keySet()) {
            to = (Resource)replaceTable.get(from);
            JenaUtil.replace(insertion, from, (Resource)to.inModel(insertion));
        }
        for (Resource from : identitiesInExisting.keySet()) {
            to = (Resource)identitiesInExisting.get(from);
            JenaUtil.replace(mainModel, from, to);
        }
    }

    static {
        handledIFP.add(FOAF.mbox);
        handledIFP.add(FOAF.mbox_sha1sum);
        handledIFP.add(FOAF.isPrimaryTopicOf);
        handledIFP.add(CALENDAR.uid);
        handledIFP.add(GEOFEX.primarySpaceThingOf);
    }
}

