/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SelectorImpl;
import com.hp.hpl.jena.shared.JenaException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.jena.AnonResDescriptor;
import org.wymiwyg.commons.jena.ResourceRenamer;

public class JenaUtil {
    private static final Log log = LogFactory.getLog(JenaUtil.class);

    public static void removeSomeDuplicateAnonymous(Model model) {
        HashSet<AnonResDescriptor> anonResDescriptors = new HashSet<AnonResDescriptor>();
        ResIterator resourceIter = model.listSubjects();
        HashSet<Resource> removingRes = new HashSet<Resource>();
        while (resourceIter.hasNext()) {
            Resource current = resourceIter.nextResource();
            if (!current.isAnon() || model.contains(null, null, (RDFNode)current)) continue;
            AnonResDescriptor descriptor = new AnonResDescriptor(current);
            if (anonResDescriptors.contains(descriptor)) {
                removingRes.add(current);
                log.info((Object)"will remove duplicate");
                continue;
            }
            anonResDescriptors.add(descriptor);
        }
        for (Resource current : removingRes) {
            current.removeProperties();
        }
        resourceIter.close();
    }

    public static void deepRemoveProperties(Resource resource) {
        StmtIterator propertiesIter = resource.listProperties();
        HashSet<Statement> propertySet = new HashSet<Statement>();
        while (propertiesIter.hasNext()) {
            propertySet.add(propertiesIter.nextStatement());
        }
        propertiesIter.close();
        for (Statement statement : propertySet) {
            JenaUtil.deepRemoveProperty(statement);
        }
    }

    public static void deepRemoveProperty(Statement property) {
        Resource object;
        if (!(property.getObject() instanceof Literal) && (object = property.getResource()).isAnon() && !JenaUtil.isObjectOfOtherStmt(object, property)) {
            ArrayList<Statement> stmtCol = new ArrayList<Statement>();
            StmtIterator iter = object.listProperties();
            while (iter.hasNext()) {
                stmtCol.add(iter.nextStatement());
            }
            iter.close();
            for (Statement current : stmtCol) {
                JenaUtil.deepRemoveProperty(current);
            }
        }
        property.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isObjectOfOtherStmt(Resource object, Statement property) {
        StmtIterator iter = object.getModel().listStatements(null, null, (RDFNode)object);
        try {
            Statement current = iter.nextStatement();
            if (!current.equals((Object)property)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            iter.close();
        }
        return false;
    }

    public static Model renameNamedResources(Model model, ResourceRenamer renamer) {
        Model result = ModelFactory.createDefaultModel();
        StmtIterator statements = model.listStatements();
        while (statements.hasNext()) {
            Statement current = statements.nextStatement();
            Resource currentSubject = current.getSubject();
            Resource subject = currentSubject.isAnon() ? currentSubject : result.createResource(renamer.getNewName(currentSubject));
            Property currentPredicate = current.getPredicate();
            Property predicate = currentPredicate.isAnon() ? currentPredicate : result.createProperty(renamer.getNewName((Resource)currentPredicate));
            RDFNode currentObject = current.getObject();
            Object object = currentObject instanceof Resource && !((Resource)currentObject).isAnon() ? result.createResource(renamer.getNewName((Resource)currentObject)) : currentObject;
            result.add(subject, predicate, object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(Model model, Resource source, Resource target) throws JenaException {
        ArrayList<Object> statementsToChangeSubject = new ArrayList<Object>();
        ArrayList<Object> statementsToChangeObject = new ArrayList<Object>();
        Model model2 = model;
        synchronized (model2) {
            StmtIterator stmtIterator = model.listStatements((Selector)new SelectorImpl(source, null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                statementsToChangeSubject.add(stmtIterator.next());
            }
            for (Statement statement : statementsToChangeSubject) {
                model.remove(statement);
                model.add(target, statement.getPredicate(), statement.getObject());
            }
            stmtIterator = model.listStatements((Selector)new SelectorImpl(null, null, (RDFNode)source));
            while (stmtIterator.hasNext()) {
                statementsToChangeObject.add(stmtIterator.next());
            }
            for (Statement statement : statementsToChangeObject) {
                model.remove(statement);
                model.add(statement.getSubject(), statement.getPredicate(), (RDFNode)target);
            }
        }
    }

    public static Model getExpandedResource(Resource resource, int expansion) {
        return JenaUtil.getExpandedResource(resource, expansion, true);
    }

    public static Model getExpandedResource(Resource resource, int expansion, boolean stopAtResWithName) {
        return JenaUtil.getExpandedResource(resource, expansion, stopAtResWithName, null);
    }

    public static Model getExpandedResource(Resource resource, int expansion, boolean stopAtResWithName, Set validProperties) {
        try {
            if (log.isDebugEnabled()) {
                StmtIterator iter = resource.listProperties();
                while (iter.hasNext()) {
                    log.debug((Object)("Available property of body: " + iter.next()));
                }
            }
            return JenaUtil.getResource(resource.getModel(), resource, expansion, ModelFactory.createDefaultModel(), stopAtResWithName, validProperties);
        }
        catch (JenaException ex) {
            log.error((Object)"Exception getting annotations", (Throwable)ex);
            throw new RuntimeException(ex.toString());
        }
    }

    private static Model getResource(Model model, final Resource resource, int expansion, Model blockModel, boolean stopAtResWithName, final Set validProperties) throws JenaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting expansion of " + resource));
        }
        Model result = validProperties == null ? model.query((Selector)new SelectorImpl(resource, null, (RDFNode)null)) : model.query(new Selector(){

            public boolean test(Statement stmt) {
                boolean result;
                boolean bl = result = stmt.getSubject().equals((Object)resource) && (validProperties.contains(stmt.getPredicate().getURI()) || stmt.getPredicate().getOrdinal() > 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(stmt.getPredicate().getURI() + " results in " + result));
                }
                return result;
            }

            public Resource getSubject() {
                return resource;
            }

            public Property getPredicate() {
                return null;
            }

            public RDFNode getObject() {
                return null;
            }

            public boolean isSimple() {
                return false;
            }
        });
        if (--expansion > 0) {
            HashSet<RDFNode> expandableResources = new HashSet<RDFNode>();
            StmtIterator attributes = result.listStatements();
            while (attributes.hasNext()) {
                Statement currentStatement = attributes.nextStatement();
                RDFNode rDFNode = currentStatement.getObject();
                Property currentProperty = currentStatement.getPredicate();
                if (validProperties != null && !validProperties.contains(currentProperty.getURI()) && currentProperty.getOrdinal() <= 0 || !(rDFNode instanceof Resource) || stopAtResWithName && !((Resource)rDFNode).isAnon()) continue;
                log.debug((Object)"will recurse if not on blockModel");
                if (blockModel.contains((Resource)rDFNode, null, (RDFNode)null)) continue;
                expandableResources.add(rDFNode);
            }
            for (Resource resource2 : expandableResources) {
                log.debug((Object)"recursing");
                result.add(JenaUtil.getResource(model, resource2, expansion, result, stopAtResWithName, validProperties));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning (result dump follows)");
            StmtIterator debugIter = result.listStatements();
            while (debugIter.hasNext()) {
                log.debug(debugIter.next());
            }
        }
        return result;
    }

    public static Resource[] getRoots(Model model) throws JenaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getting roots of:");
            StringWriter stringWriter = new StringWriter();
            model.write((Writer)stringWriter);
            log.debug((Object)stringWriter.toString());
        }
        ArrayList<Resource> resultList = new ArrayList<Resource>();
        ResIterator subjectIterator = model.listSubjects();
        HashSet<RDFNode> objectSet = new HashSet<RDFNode>();
        NodeIterator objectIterator = model.listObjects();
        while (objectIterator.hasNext()) {
            RDFNode node = objectIterator.nextNode();
            if (!(node instanceof Resource)) continue;
            objectSet.add(node);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(node + " added to objectset"));
        }
        while (subjectIterator.hasNext()) {
            Resource resource = subjectIterator.nextResource();
            if (!objectSet.contains(resource)) {
                resultList.add(resource);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(resource + " is also an object"));
        }
        return resultList.toArray(new Resource[resultList.size()]);
    }
}

