/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.util.Util;
import org.wymiwyg.commons.vocabulary.FOAF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCreationUtil {
    private static final Log log;
    private static Model m_model;
    private static List<Resource> resourceCandidates;
    private static List<Property> predicateCandidates;
    private static List<Literal> literalCandidates;

    public static Model createRandomModel(int size) {
        Model model = ModelFactory.createDefaultModel();
        log.debug((Object)("trans: " + model.supportsTransactions()));
        ArrayList<Resource> usedResources = new ArrayList<Resource>((int)(1.2 * (double)size));
        for (int i = 0; i < size; ++i) {
            ModelCreationUtil.addRandomTriple(model, usedResources);
            if (i <= 0 || i % 100000 != 0) continue;
            log.info((Object)("pos  " + i));
        }
        return model;
    }

    private static void addRandomTriple(Model model, List<Resource> usedResources) {
        Resource subject = ModelCreationUtil.getRandomSubject(usedResources);
        Property predicate = ModelCreationUtil.getRandomPredicate();
        RDFNode object = ModelCreationUtil.getRandomObject(usedResources);
        model.add(subject, predicate, object);
    }

    private static RDFNode getRandomObject(List<Resource> usedResources) {
        if (usedResources.size() < 3 || Math.random() > 0.8) {
            if (Math.random() > 0.6) {
                return (RDFNode)ModelCreationUtil.getRandomFromList(literalCandidates);
            }
            Resource resource = ModelCreationUtil.getRandomFromList(resourceCandidates);
            usedResources.add(resource);
            return resource;
        }
        return (RDFNode)ModelCreationUtil.getRandomFromList(usedResources);
    }

    private static Property getRandomPredicate() {
        return ModelCreationUtil.getRandomFromList(predicateCandidates);
    }

    private static Resource getRandomSubject(List<Resource> usedResources) {
        if (usedResources.size() < 3 || Math.random() > 0.8) {
            Resource resource = ModelCreationUtil.getRandomFromList(resourceCandidates);
            usedResources.add(resource);
            return resource;
        }
        return ModelCreationUtil.getRandomFromList(usedResources);
    }

    private static <T> T getRandomFromList(List<T> list) {
        int position = (int)(Math.random() * (double)(list.size() - 1));
        return list.get(position);
    }

    static {
        int i;
        log = LogFactory.getLog(ModelCreationUtil.class);
        m_model = ModelFactory.createDefaultModel();
        resourceCandidates = new ArrayList<Resource>();
        for (i = 0; i < 5000; ++i) {
            if (Math.random() > 0.2) {
                resourceCandidates.add(m_model.createResource());
                continue;
            }
            resourceCandidates.add(m_model.createResource(Util.createURN5()));
        }
        predicateCandidates = new ArrayList<Property>();
        predicateCandidates.add(FOAF.mbox);
        predicateCandidates.add(FOAF.mbox_sha1sum);
        predicateCandidates.add(FOAF.homepage);
        predicateCandidates.add(FOAF.interest);
        predicateCandidates.add(FOAF.primaryTopic);
        predicateCandidates.add(FOAF.gender);
        for (i = 0; i < 30; ++i) {
            predicateCandidates.add(m_model.createProperty("http://" + Util.createRandomString((int)8) + "/" + Util.createRandomString((int)4)));
        }
        literalCandidates = new ArrayList<Literal>();
        for (i = 0; i < 200; ++i) {
            StringBuffer buffer = new StringBuffer();
            while (Math.random() > 0.2) {
                buffer.append(Util.createRandomString((int)((int)(Math.random() * 50.0))));
                if (!(Math.random() > 0.1)) continue;
                buffer.append(' ');
            }
            literalCandidates.add(m_model.createLiteral(buffer.toString()));
        }
    }
}

