/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NamedResourceGenerator {
    public static final int MAX_NAME_LENGTH = 30;
    public static final int PREFFERRED_NAME_LENGTH = 12;

    public static String createURLPart(String title, Date date) {
        StringBuffer out = new StringBuffer();
        out.append(new SimpleDateFormat("yyyy/MM/dd/").format(date));
        try {
            out.append(URLEncoder.encode(title, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        return out.toString();
    }

    private static String getName(String title) {
        StringBuffer out = new StringBuffer();
        int dotPos = title.indexOf(46);
        StringReader in = dotPos != -1 ? new StringReader(title.substring(0, dotPos).toLowerCase()) : new StringReader(title.toLowerCase());
        StringWriter wordBuffer = null;
        try {
            int ch = in.read();
            while (true) {
                if (ch == -1) {
                    if (wordBuffer != null && out.length() + wordBuffer.toString().length() <= 30) {
                        out.append(wordBuffer.toString());
                    }
                    break;
                }
                if (out.length() >= 30) break;
                if (ch == 32) {
                    ch = 45;
                }
                if (ch == 45) {
                    if (out.length() < 12) {
                        out.append((char)ch);
                    } else {
                        if (wordBuffer != null) {
                            String wordBufferString = wordBuffer.toString();
                            if (out.length() + wordBufferString.length() > 30) break;
                            out.append(wordBufferString);
                            if (out.length() > 12) break;
                        }
                        wordBuffer = new StringWriter();
                        wordBuffer.write(ch);
                    }
                } else if (URLEncoder.encode(Character.toString((char)ch), "utf-8").equals(Character.toString((char)ch))) {
                    if (wordBuffer != null) {
                        wordBuffer.write(ch);
                    } else {
                        out.append((char)ch);
                    }
                }
                ch = in.read();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    public static Resource createNewResource(Model model, URL urlBase, String title) {
        return NamedResourceGenerator.createNewResourceFromSuffix(model, urlBase, NamedResourceGenerator.getName(title));
    }

    public static Resource createNewResource(Model model, URL urlBase, String title, Date date) {
        return NamedResourceGenerator.createNewResourceFromSuffix(model, urlBase, NamedResourceGenerator.getName(title), date);
    }

    public static Resource createNewResourceFromSuffix(Model model, URL urlBase, String suffix) {
        return NamedResourceGenerator.createNewResourceFromSuffix(model, urlBase, suffix, new Date());
    }

    public static Resource createNewResourceFromSuffix(Model model, URL urlBase, String suffix, Date date) {
        StringBuffer resourceURL;
        if (suffix.length() > 0 && suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        if ((resourceURL = new StringBuffer(urlBase.toString())).charAt(resourceURL.length() - 1) != '/') {
            resourceURL.append('/');
        }
        resourceURL.append(NamedResourceGenerator.createURLPart(suffix, date));
        Resource resource = model.createResource(resourceURL.toString());
        int pos = 1;
        while (resource.listProperties().hasNext()) {
            resource = model.createResource(resourceURL.toString() + '-' + pos++);
        }
        return resource;
    }
}

