/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.modelcache;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheGraph
extends GraphMem {
    private GraphBase baseGraph;
    private static Log logger = LogFactory.getLog(CacheGraph.class);

    public CacheGraph(GraphBase baseGraph) throws IOException {
        super(ReificationStyle.Standard);
        this.baseGraph = baseGraph;
        ExtendedIterator iterator = baseGraph.find(null, null, null);
        while (iterator.hasNext()) {
            super.performAdd((Triple)iterator.next());
        }
        iterator.close();
    }

    public synchronized void performAdd(Triple triple) {
        super.performAdd(triple);
        this.baseGraph.performAdd(triple);
    }

    public synchronized void performDelete(Triple triple) {
        super.performDelete(triple);
        this.baseGraph.performDelete(triple);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new SimpleBulkUpdateHandler((GraphWithPerform)this);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }
}

