/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.modellazywriter;

import com.hp.hpl.jena.rdf.model.Model;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.wymiwyg.commons.modellazywriter.ModelAction;

public class ActionHandler {
    private Reference modelRef;
    private LinkedList actionList = new LinkedList();
    private static WeakHashMap map = new WeakHashMap();

    private ActionHandler(Model model) {
        final ReferenceQueue queue = new ReferenceQueue();
        this.modelRef = new WeakReference<Model>(model, queue);
        new Thread(){

            public void run() {
                try {
                    queue.remove();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ActionHandler.this.performActions();
            }
        }.start();
    }

    public void performActions() {
        if (this.actionList.size() != 0) {
            Model model = (Model)this.modelRef.get();
            model.enterCriticalSection(false);
            try {
                while (this.actionList.size() != 0) {
                    ModelAction action = (ModelAction)this.actionList.removeFirst();
                    action.perform(model);
                }
            }
            finally {
                model.leaveCriticalSection();
            }
        }
    }

    public synchronized void addAction(ModelAction action) {
        this.actionList.add(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionHandler getActionHandler(Model model) {
        ActionHandler result = (ActionHandler)map.get(model);
        if (result != null) return result;
        Class<ActionHandler> clazz = ActionHandler.class;
        synchronized (ActionHandler.class) {
            result = (ActionHandler)map.get(model);
            if (result != null) return result;
            result = new ActionHandler(model);
            map.put(model, result);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }
}

