/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.prevamodel;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import com.hp.hpl.jena.graph.impl.SimpleTransactionHandler;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wymiwyg.commons.prevamodel.StroringThread;

public class PrevaGraph
extends GraphMem {
    private File directory;
    private int counter = 1;
    private static Log logger = LogFactory.getLog(PrevaGraph.class);

    public PrevaGraph(String directoryPath, int storeInterval) throws IOException {
        super(ReificationStyle.Standard);
        this.directory = new File(directoryPath);
        this.directory.mkdirs();
        long storeIntervalMilis = 60000 * storeInterval;
        try {
            this.read();
        }
        catch (Exception e) {
            logger.error((Object)"restoring PrevaModel", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.store();
        if (storeInterval > 0) {
            StroringThread storingThread = new StroringThread(this, storeIntervalMilis);
            storingThread.setDaemon(true);
            storingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String command, Triple triple) {
        PrevaGraph prevaGraph = this;
        synchronized (prevaGraph) {
            try {
                FileWriter writer = new FileWriter(new File(this.directory, "log-" + this.counter++ + "-" + command));
                this.writeStatement(triple, writer);
                ((Writer)writer).close();
            }
            catch (Exception e) {
                logger.error((Object)("Writing log " + e));
                throw new RuntimeException(e.toString());
            }
        }
    }

    private void writeStatement(Triple triple, Writer writer) throws IOException {
        GraphMem stmtGraph = new GraphMem();
        stmtGraph.add(triple);
        Model stmtModel = ModelFactory.createModelForGraph((Graph)stmtGraph);
        stmtModel.write(writer, "N-TRIPLE");
    }

    public synchronized void removeLogs() {
        File[] logFiles = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("log-");
            }
        });
        for (int i = 0; i < logFiles.length; ++i) {
            logFiles[i].delete();
        }
        this.counter = 1;
    }

    public synchronized void performAdd(Triple triple) {
        super.performAdd(triple);
        if (logger.isDebugEnabled()) {
            try {
                throw new Exception("harmless debug-exception");
            }
            catch (Exception ex) {
                logger.debug((Object)("writing triple: " + triple), (Throwable)ex);
            }
        }
        this.log("add", triple);
    }

    public synchronized void performDelete(Triple triple) {
        super.performDelete(triple);
        this.log("delete", triple);
    }

    private void read() throws IOException {
        final HashSet<String> triples = new HashSet<String>();
        File defaultStore = new File(this.directory, "store.rdf");
        File newStore = new File(this.directory, "store-new.rdf");
        if (defaultStore.exists()) {
            if (newStore.exists()) {
                newStore.delete();
            }
            BufferedReader in = new BufferedReader(new FileReader(defaultStore));
            String line = in.readLine();
            while (line != null) {
                triples.add(line);
                line = in.readLine();
            }
            in.close();
        } else if (newStore.exists()) {
            newStore.renameTo(defaultStore);
        }
        String[] logFiles = this.directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("log-");
            }
        });
        Arrays.sort(logFiles, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return this.getLogNumber((String)arg0) - this.getLogNumber((String)arg1);
            }

            private int getLogNumber(String string) {
                String substring = string.substring(4);
                int endOfNumer = substring.indexOf(45);
                String numberString = substring.substring(0, endOfNumer);
                return Integer.parseInt(numberString);
            }
        });
        for (int i = 0; i < logFiles.length; ++i) {
            File log = new File(this.directory, logFiles[i]);
            BufferedReader logIn = new BufferedReader(new FileReader(log));
            String entry = logIn.readLine();
            String nextLine = logIn.readLine();
            if (nextLine != null) {
                throw new RuntimeException(log + " is multiline");
            }
            if (entry == null) {
                logger.warn((Object)(log + " is empty, ignoring"));
                continue;
            }
            logIn.close();
            if (logFiles[i].indexOf("add") != -1) {
                triples.add(entry);
                continue;
            }
            triples.remove(entry);
        }
        PipedReader pipedIn = new PipedReader();
        final PipedWriter pipedOut = new PipedWriter(pipedIn);
        new Thread(){

            public void run() {
                PrintWriter printOut = new PrintWriter(new BufferedWriter(pipedOut));
                for (String element : triples) {
                    printOut.println(element);
                }
                printOut.close();
            }
        }.start();
        ModelFactory.createModelForGraph((Graph)this).read((Reader)pipedIn, "", "N-TRIPLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() throws IOException {
        long start = System.currentTimeMillis();
        PrevaGraph prevaGraph = this;
        synchronized (prevaGraph) {
            String[] logFiles = this.directory.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("log-");
                }
            });
            if (logFiles.length > 0) {
                logger.info((Object)"reducing disk representation of prevagraph to one file");
                Model model = ModelFactory.createModelForGraph((Graph)this);
                File newStore = new File(this.directory, "store-new.rdf");
                FileWriter writer = new FileWriter(newStore);
                model.write((Writer)writer, "N-TRIPLE");
                ((Writer)writer).close();
                File defaultStore = new File(this.directory, "store.rdf");
                if (defaultStore.exists()) {
                    defaultStore.delete();
                }
                newStore.renameTo(defaultStore);
                this.removeLogs();
            }
        }
        logger.info((Object)("log maintance too " + (System.currentTimeMillis() - start) + " ms"));
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new SimpleBulkUpdateHandler((GraphWithPerform)this);
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }
}

